/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.storageengine.api.RelationshipTypeItem;

class RelationshipTypeDenseCursor
implements Cursor<RelationshipTypeItem>,
RelationshipTypeItem {
    private final RelationshipGroupRecord groupRecord;
    private RecordCursors recordCursors;
    private long groupId;
    private int value = -1;

    RelationshipTypeDenseCursor(long groupId, RelationshipGroupRecord groupRecord, RecordCursors recordCursors) {
        this.groupId = groupId;
        this.groupRecord = groupRecord;
        this.recordCursors = recordCursors;
    }

    public boolean next() {
        while (this.groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            boolean groupRecordInUse = this.recordCursors.relationshipGroup().next(this.groupId, this.groupRecord, RecordLoad.FORCE);
            this.groupId = this.groupRecord.getNext();
            if (!groupRecordInUse) continue;
            this.value = this.groupRecord.getType();
            return true;
        }
        this.value = -1;
        return false;
    }

    public void close() {
    }

    public RelationshipTypeItem get() {
        return this;
    }

    @Override
    public int getAsInt() {
        return this.value;
    }
}

