/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.api.store.DegreeItemCursor;
import org.neo4j.kernel.impl.api.store.DegreeItemDenseCursor;
import org.neo4j.kernel.impl.api.store.StoreLabelCursor;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleLabelCursor;
import org.neo4j.kernel.impl.api.store.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.DegreeItem;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;

class NodeExploringCursors {
    private final InstanceCache<StoreLabelCursor> labelCursorCache;
    private final InstanceCache<StoreSingleLabelCursor> singleLabelCursorCache;
    private final InstanceCache<StoreNodeRelationshipCursor> nodeRelationshipCursorCache;
    private final InstanceCache<StoreSinglePropertyCursor> singlePropertyCursorCache;
    private final InstanceCache<StorePropertyCursor> propertyCursorCache;
    private final RelationshipStore relationshipStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;

    NodeExploringCursors(final RecordCursors cursors, final LockService lockService, final RelationshipStore relationshipStore, final RecordStore<RelationshipGroupRecord> relationshipGroupStore) {
        this.labelCursorCache = new InstanceCache<StoreLabelCursor>(){

            @Override
            protected StoreLabelCursor create() {
                return new StoreLabelCursor(cursors.label(), NodeExploringCursors.this.labelCursorCache);
            }
        };
        this.singleLabelCursorCache = new InstanceCache<StoreSingleLabelCursor>(){

            @Override
            protected StoreSingleLabelCursor create() {
                return new StoreSingleLabelCursor(cursors.label(), NodeExploringCursors.this.singleLabelCursorCache);
            }
        };
        this.relationshipStore = relationshipStore;
        this.relationshipGroupStore = relationshipGroupStore;
        this.nodeRelationshipCursorCache = new InstanceCache<StoreNodeRelationshipCursor>(){

            @Override
            protected StoreNodeRelationshipCursor create() {
                return new StoreNodeRelationshipCursor((RelationshipRecord)relationshipStore.newRecord(), (RelationshipGroupRecord)relationshipGroupStore.newRecord(), NodeExploringCursors.this.nodeRelationshipCursorCache, cursors, lockService);
            }
        };
        this.singlePropertyCursorCache = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(cursors, NodeExploringCursors.this.singlePropertyCursorCache);
            }
        };
        this.propertyCursorCache = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(cursors, NodeExploringCursors.this.propertyCursorCache);
            }
        };
    }

    public Cursor<PropertyItem> properties(long nextProp, Lock lock) {
        return this.propertyCursorCache.get().init(nextProp, lock);
    }

    public Cursor<PropertyItem> property(long nextProp, int propertyKeyId, Lock lock) {
        return this.singlePropertyCursorCache.get().init(nextProp, propertyKeyId, lock);
    }

    public Cursor<LabelItem> labels(NodeRecord nodeRecord) {
        return this.labelCursorCache.get().init(nodeRecord);
    }

    public Cursor<LabelItem> label(NodeRecord nodeRecord, int labelId) {
        return this.singleLabelCursorCache.get().init(nodeRecord, labelId);
    }

    public Cursor<RelationshipItem> relationships(boolean dense, long nextRel, long id, Direction direction) {
        return this.nodeRelationshipCursorCache.get().init(dense, nextRel, id, direction);
    }

    public Cursor<RelationshipItem> relationships(boolean dense, long nextRel, long id, Direction direction, int ... relTypes) {
        return this.nodeRelationshipCursorCache.get().init(dense, nextRel, id, direction, relTypes);
    }

    public Cursor<DegreeItem> degrees(PrimitiveIntObjectMap<int[]> degrees) {
        return new DegreeItemCursor(degrees);
    }

    public Cursor<DegreeItem> degrees(long groupId, NodeRecord nodeRecord, RecordCursors recordCursors) {
        return new DegreeItemDenseCursor(groupId, nodeRecord, this.relationshipGroupStore.newRecord(), (RelationshipRecord)this.relationshipStore.newRecord(), recordCursors);
    }
}

