/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.api.store.DegreeCounter;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.DegreeItem;

class DegreeItemDenseCursor
implements Cursor<DegreeItem>,
DegreeItem {
    private final NodeRecord nodeRecord;
    private final RelationshipGroupRecord relationshipGroupRecord;
    private final RelationshipRecord relationshipRecord;
    private final RecordCursors recordCursors;
    private long groupId;
    private int type;
    private long outgoing;
    private long incoming;

    DegreeItemDenseCursor(long groupId, NodeRecord nodeRecord, RelationshipGroupRecord relationshipGroupRecord, RelationshipRecord relationshipRecord, RecordCursors recordCursors) {
        this.groupId = groupId;
        this.nodeRecord = nodeRecord;
        this.relationshipGroupRecord = relationshipGroupRecord;
        this.relationshipRecord = relationshipRecord;
        this.recordCursors = recordCursors;
    }

    public boolean next() {
        while (this.groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            boolean groupRecordInUse = this.recordCursors.relationshipGroup().next(this.groupId, this.relationshipGroupRecord, RecordLoad.FORCE);
            this.groupId = this.relationshipGroupRecord.getNext();
            if (!groupRecordInUse) continue;
            this.type = this.relationshipGroupRecord.getType();
            long firstLoop = this.relationshipGroupRecord.getFirstLoop();
            long firstOut = this.relationshipGroupRecord.getFirstOut();
            long firstIn = this.relationshipGroupRecord.getFirstIn();
            RecordCursor<RelationshipRecord> relationshipCursor = this.recordCursors.relationship();
            long loop = DegreeCounter.countByFirstPrevPointer(firstLoop, relationshipCursor, this.nodeRecord, this.relationshipRecord);
            this.outgoing = DegreeCounter.countByFirstPrevPointer(firstOut, relationshipCursor, this.nodeRecord, this.relationshipRecord) + loop;
            this.incoming = DegreeCounter.countByFirstPrevPointer(firstIn, relationshipCursor, this.nodeRecord, this.relationshipRecord) + loop;
            return true;
        }
        return false;
    }

    public void close() {
    }

    public DegreeItem get() {
        return this;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public long outgoing() {
        return this.outgoing;
    }

    @Override
    public long incoming() {
        return this.incoming;
    }
}

