/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.cursor.Cursor;
import org.neo4j.storageengine.api.DegreeItem;

class DegreeItemCursor
implements Cursor<DegreeItem>,
DegreeItem {
    private final PrimitiveIntObjectMap<int[]> degrees;
    private PrimitiveIntIterator keys;
    private int type;
    private int outgoing;
    private int incoming;

    DegreeItemCursor(PrimitiveIntObjectMap<int[]> degrees) {
        this.keys = degrees.iterator();
        this.degrees = degrees;
    }

    public void close() {
        this.keys = null;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public long outgoing() {
        return this.outgoing;
    }

    @Override
    public long incoming() {
        return this.incoming;
    }

    public DegreeItem get() {
        if (this.keys == null) {
            throw new IllegalStateException("No next item found");
        }
        return this;
    }

    public boolean next() {
        if (this.keys != null && this.keys.hasNext()) {
            this.type = this.keys.next();
            int[] degreeValues = (int[])this.degrees.get(this.type);
            this.outgoing = degreeValues[0] + degreeValues[2];
            this.incoming = degreeValues[1] + degreeValues[2];
            return true;
        }
        this.keys = null;
        return false;
    }
}

