/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.Direction;

class DegreeCounter {
    private DegreeCounter() {
    }

    static long countByFirstPrevPointer(long relationshipId, RecordCursor<RelationshipRecord> cursor, NodeRecord nodeRecord, RelationshipRecord relationshipRecord) {
        if (relationshipId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            return 0L;
        }
        cursor.next(relationshipId, relationshipRecord, RecordLoad.FORCE);
        if (relationshipRecord.getFirstNode() == nodeRecord.getId()) {
            return relationshipRecord.getFirstPrevRel();
        }
        if (relationshipRecord.getSecondNode() == nodeRecord.getId()) {
            return relationshipRecord.getSecondPrevRel();
        }
        throw new InvalidRecordException("Node " + nodeRecord.getId() + " neither start nor end node of " + relationshipRecord);
    }

    static int countRelationshipsInGroup(long groupId, Direction direction, Integer type, NodeRecord nodeRecord, RelationshipRecord relationshipRecord, RelationshipGroupRecord groupRecord, RecordCursors cursors) {
        int count = 0;
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            boolean groupRecordInUse = cursors.relationshipGroup().next(groupId, groupRecord, RecordLoad.FORCE);
            if (groupRecordInUse && (type == null || groupRecord.getType() == type.intValue())) {
                count = (int)((long)count + DegreeCounter.nodeDegreeByDirection(direction, nodeRecord, relationshipRecord, groupRecord, cursors));
                if (type != null) break;
            }
            groupId = groupRecord.getNext();
        }
        return count;
    }

    private static long nodeDegreeByDirection(Direction direction, NodeRecord nodeRecord, RelationshipRecord relationshipRecord, RelationshipGroupRecord groupRecord, RecordCursors cursors) {
        RecordCursor<RelationshipRecord> cursor = cursors.relationship();
        long loopCount = DegreeCounter.countByFirstPrevPointer(groupRecord.getFirstLoop(), cursor, nodeRecord, relationshipRecord);
        switch (direction) {
            case OUTGOING: {
                long firstOut = groupRecord.getFirstOut();
                return DegreeCounter.countByFirstPrevPointer(firstOut, cursor, nodeRecord, relationshipRecord) + loopCount;
            }
            case INCOMING: {
                long firstIn = groupRecord.getFirstIn();
                return DegreeCounter.countByFirstPrevPointer(firstIn, cursor, nodeRecord, relationshipRecord) + loopCount;
            }
            case BOTH: {
                long firstOut = groupRecord.getFirstOut();
                long firstIn = groupRecord.getFirstIn();
                return DegreeCounter.countByFirstPrevPointer(firstOut, cursor, nodeRecord, relationshipRecord) + DegreeCounter.countByFirstPrevPointer(firstIn, cursor, nodeRecord, relationshipRecord) + loopCount;
            }
        }
        throw new IllegalArgumentException(direction.name());
    }
}

