/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.IndexDescriptorFactory;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.IndexSchemaRule;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class CacheLayer
implements StoreReadLayer {
    private final SchemaCache schemaCache;
    private final DiskLayer diskLayer;

    public CacheLayer(DiskLayer diskLayer, SchemaCache schemaCache) {
        this.diskLayer = diskLayer;
        this.schemaCache = schemaCache;
    }

    @Override
    public StorageStatement newStatement() {
        return this.diskLayer.newStatement();
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniquenessIndexesGetForLabel(int labelId) {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRulesForLabel(labelId), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniquenessIndexesGetAll() {
        return CacheLayer.toIndexDescriptors(this.schemaCache.schemaRules(), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    private static Iterator<IndexDescriptor> toIndexDescriptors(Iterable<SchemaRule> rules, SchemaRule.Kind kind) {
        Iterator filteredRules = Iterators.filter(item -> item.getKind() == kind, rules.iterator());
        return Iterators.map(from -> IndexDescriptorFactory.of((IndexRule)from), (Iterator)filteredRules);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexSchemaRule rule = this.indexRule(index, Predicates.alwaysTrue());
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return this.diskLayer.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index, Predicate<SchemaRule.Kind> filter) throws SchemaRuleNotFoundException {
        IndexSchemaRule rule = this.indexRule(index, filter);
        if (rule != null) {
            return rule.getId();
        }
        return this.diskLayer.indexGetCommittedId(index, filter);
    }

    @Override
    public IndexSchemaRule indexRule(IndexDescriptor index, Predicate<SchemaRule.Kind> filter) {
        for (SchemaRule rule : this.schemaCache.schemaRulesForLabel(index.getLabelId())) {
            IndexSchemaRule indexRule;
            if (!(rule instanceof IndexSchemaRule) || !filter.test((indexRule = (IndexSchemaRule)rule).getKind()) || !indexRule.matches(index.descriptor())) continue;
            return indexRule;
        }
        return null;
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys() {
        return this.diskLayer.graphGetPropertyKeys();
    }

    @Override
    public Object graphGetProperty(int propertyKeyId) {
        return this.diskLayer.graphGetProperty(propertyKeyId);
    }

    @Override
    public Iterator<StorageProperty> graphGetAllProperties() {
        return this.diskLayer.graphGetAllProperties();
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(NodePropertyDescriptor descriptor) {
        return this.schemaCache.constraintsForLabelAndProperty(descriptor);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(RelationshipPropertyDescriptor descriptor) {
        return this.schemaCache.constraintsForRelationshipTypeAndProperty(descriptor);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(int typeId) {
        return this.schemaCache.constraintsForRelationshipType(typeId);
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll() {
        return this.schemaCache.constraints();
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(StorageStatement state, int labelId) {
        return this.diskLayer.nodesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexGetForLabelAndPropertyKey(NodePropertyDescriptor descriptor) {
        return this.schemaCache.indexDescriptor(descriptor);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetState(descriptor);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetPopulationProgress(descriptor);
    }

    @Override
    public long indexSize(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexSize(descriptor);
    }

    @Override
    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.diskLayer.indexGetFailure(descriptor);
    }

    @Override
    public int labelGetForName(String labelName) {
        return this.diskLayer.labelGetForName(labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        return this.diskLayer.labelGetName(labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetForName(propertyKeyName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) {
        return this.diskLayer.propertyKeyGetOrCreateForName(propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        return this.diskLayer.propertyKeyGetName(propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.diskLayer.propertyKeyGetAllTokens();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.diskLayer.labelsGetAllTokens();
    }

    @Override
    public Iterator<Token> relationshipTypeGetAllTokens() {
        return this.diskLayer.relationshipTypeGetAllTokens();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetForName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        return this.diskLayer.relationshipTypeGetName(relationshipTypeId);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws TooManyLabelsException {
        return this.diskLayer.labelGetOrCreateForName(labelName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.diskLayer.relationshipTypeGetOrCreateForName(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        this.diskLayer.relationshipVisit(relationshipId, relationshipVisitor);
    }

    @Override
    public long countsForNode(int labelId) {
        return this.diskLayer.countsForNode(labelId);
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.diskLayer.countsForRelationship(startLabelId, typeId, endLabelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return this.diskLayer.nodesGetAll();
    }

    @Override
    public RelationshipIterator relationshipsGetAll() {
        return this.diskLayer.relationshipsGetAll();
    }

    @Override
    public long reserveNode() {
        return this.diskLayer.reserveNode();
    }

    @Override
    public long reserveRelationship() {
        return this.diskLayer.reserveRelationship();
    }

    @Override
    public void releaseNode(long id) {
        this.diskLayer.releaseNode(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.diskLayer.releaseRelationship(id);
    }

    @Override
    public long nodesGetCount() {
        return this.diskLayer.nodesGetCount();
    }

    @Override
    public long relationshipsGetCount() {
        return this.diskLayer.relationshipsGetCount();
    }

    @Override
    public int labelCount() {
        return this.diskLayer.labelCount();
    }

    @Override
    public int propertyKeyCount() {
        return this.diskLayer.propertyKeyCount();
    }

    @Override
    public int relationshipTypeCount() {
        return this.diskLayer.relationshipTypeCount();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor index, Register.DoubleLongRegister target) {
        return this.diskLayer.indexUpdatesAndSize(index, target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexDescriptor index, Register.DoubleLongRegister target) {
        return this.diskLayer.indexSample(index, target);
    }

    @Override
    public boolean nodeExists(long id) {
        return this.diskLayer.nodeExists(id);
    }
}

