/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LoggingMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;

public class NativeLabelScanStoreExtension
extends KernelExtensionFactory<Dependencies> {
    public static final String LABEL_SCAN_STORE_NAME = "native";
    private final int priority;
    private final LabelScanStore.Monitor monitor;

    public NativeLabelScanStoreExtension() {
        this(0, LabelScanStore.Monitor.EMPTY);
    }

    public NativeLabelScanStoreExtension(int priority, LabelScanStore.Monitor monitor) {
        super(LABEL_SCAN_STORE_NAME);
        this.priority = priority;
        this.monitor = monitor;
    }

    @Override
    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        Log log = dependencies.getLogService().getInternalLog(NativeLabelScanStore.class);
        LoggingMonitor monitor = new LoggingMonitor(log, this.monitor);
        NativeLabelScanStore labelScanStore = new NativeLabelScanStore(dependencies.pageCache(), context.storeDir(), new FullLabelStream(dependencies.indexStoreView()), dependencies.getConfig().get(GraphDatabaseSettings.read_only), monitor);
        return new LabelScanStoreProvider(LABEL_SCAN_STORE_NAME, labelScanStore, this.priority);
    }

    public static interface Dependencies {
        public Config getConfig();

        public PageCache pageCache();

        public Supplier<IndexStoreView> indexStoreView();

        public LogService getLogService();
    }
}

