/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LabelScanStoreProvider
extends LifecycleAdapter
implements Comparable<LabelScanStoreProvider> {
    private static final String KEY = "lucene";
    private final String name;
    private final LabelScanStore labelScanStore;
    private final int priority;

    public LabelScanStoreProvider(String name, LabelScanStore labelScanStore, int priority) {
        this.name = name;
        this.labelScanStore = labelScanStore;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public static File getStoreDirectory(File storeRootDir) {
        return new File(new File(new File(storeRootDir, "schema"), "label"), KEY);
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    @Override
    public int compareTo(LabelScanStoreProvider o) {
        return this.priority - o.priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.labelScanStore + ", prio:" + this.priority + "]";
    }

    public static long rebuild(LabelScanStore store, FullStoreChangeStream fullStoreStream) throws IOException {
        try (LabelScanWriter writer = store.newWriter();){
            long l = fullStoreStream.applyTo(writer);
            return l;
        }
    }
}

