/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedPopulatingIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexCountsRemover;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.PopulatingIndexProxy;
import org.neo4j.kernel.impl.api.index.RecoveringIndexProxy;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.logging.LogProvider;

public class IndexProxyCreator {
    private final IndexSamplingConfig samplingConfig;
    private final IndexStoreView storeView;
    private final SchemaIndexProviderMap providerMap;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;

    public IndexProxyCreator(IndexSamplingConfig samplingConfig, IndexStoreView storeView, SchemaIndexProviderMap providerMap, TokenNameLookup tokenNameLookup, LogProvider logProvider) {
        this.samplingConfig = samplingConfig;
        this.storeView = storeView;
        this.providerMap = providerMap;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
    }

    public IndexProxy createPopulatingIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, IndexConfiguration config, boolean flipToTentative, IndexingService.Monitor monitor, IndexPopulationJob populationJob) throws IOException {
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexPopulator populator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, config, this.samplingConfig);
        FailedPopulatingIndexProxyFactory failureDelegateFactory = new FailedPopulatingIndexProxyFactory(descriptor, config, providerDescriptor, populator, indexUserDescription, new IndexCountsRemover(this.storeView, descriptor), this.logProvider);
        PopulatingIndexProxy populatingIndex = new PopulatingIndexProxy(descriptor, config, providerDescriptor, populationJob);
        populationJob.addPopulator(populator, descriptor, config, providerDescriptor, indexUserDescription, flipper, failureDelegateFactory);
        flipper.flipTo(populatingIndex);
        flipper.setFlipTarget(() -> {
            monitor.populationCompleteOn(descriptor);
            OnlineIndexProxy onlineProxy = new OnlineIndexProxy(descriptor, config, this.onlineAccessorFromProvider(providerDescriptor, ruleId, config, this.samplingConfig), this.storeView, providerDescriptor, true);
            if (flipToTentative) {
                return new TentativeConstraintIndexProxy(flipper, onlineProxy);
            }
            return onlineProxy;
        });
        return new ContractCheckingIndexProxy(flipper, false);
    }

    public IndexProxy createRecoveringIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean constraint) {
        IndexConfiguration configuration = IndexConfiguration.of(constraint);
        RecoveringIndexProxy proxy = new RecoveringIndexProxy(descriptor, providerDescriptor, configuration);
        return new ContractCheckingIndexProxy(proxy, true);
    }

    public IndexProxy createOnlineIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean unique) {
        try {
            IndexConfiguration config = IndexConfiguration.of(unique);
            IndexAccessor onlineAccessor = this.onlineAccessorFromProvider(providerDescriptor, ruleId, config, this.samplingConfig);
            IndexProxy proxy = new OnlineIndexProxy(descriptor, config, onlineAccessor, this.storeView, providerDescriptor, false);
            proxy = new ContractCheckingIndexProxy(proxy, true);
            return proxy;
        }
        catch (IOException e) {
            this.logProvider.getLog(this.getClass()).error("Failed to open index: " + ruleId + " (" + descriptor.userDescription(this.tokenNameLookup) + "), requesting re-population.", (Throwable)e);
            return this.createRecoveringIndexProxy(descriptor, providerDescriptor, unique);
        }
    }

    public IndexProxy createFailedIndexProxy(long ruleId, IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, boolean unique, IndexPopulationFailure populationFailure) {
        IndexConfiguration config = IndexConfiguration.of(unique);
        IndexPopulator indexPopulator = this.populatorFromProvider(providerDescriptor, ruleId, descriptor, config, this.samplingConfig);
        String indexUserDescription = this.indexUserDescription(descriptor, providerDescriptor);
        IndexProxy proxy = new FailedIndexProxy(descriptor, config, providerDescriptor, indexUserDescription, indexPopulator, populationFailure, new IndexCountsRemover(this.storeView, descriptor), this.logProvider);
        proxy = new ContractCheckingIndexProxy(proxy, true);
        return proxy;
    }

    private String indexUserDescription(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor) {
        return String.format("%s [provider: %s]", descriptor.userDescription(this.tokenNameLookup), providerDescriptor.toString());
    }

    private IndexPopulator populatorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexDescriptor descriptor, IndexConfiguration indexConfig, IndexSamplingConfig samplingConfig) {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getPopulator(ruleId, descriptor, indexConfig, samplingConfig);
    }

    private IndexAccessor onlineAccessorFromProvider(SchemaIndexProvider.Descriptor providerDescriptor, long ruleId, IndexConfiguration indexConfig, IndexSamplingConfig samplingConfig) throws IOException {
        SchemaIndexProvider indexProvider = this.providerMap.apply(providerDescriptor);
        return indexProvider.getOnlineAccessor(ruleId, indexConfig, samplingConfig);
    }
}

