/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.EntityItemHelper;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.DegreeItem;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.RelationshipTypeItem;
import org.neo4j.storageengine.api.txstate.NodeState;

public class TxSingleNodeCursor
extends EntityItemHelper
implements Cursor<NodeItem>,
NodeItem {
    private final TransactionState state;
    private final Consumer<TxSingleNodeCursor> cache;
    private long id = -1L;
    private Cursor<NodeItem> cursor;
    private NodeState nodeState;
    private boolean nodeIsAddedInThisTx;

    public TxSingleNodeCursor(TransactionState state, Consumer<TxSingleNodeCursor> cache) {
        this.state = state;
        this.cache = cache;
    }

    public TxSingleNodeCursor init(Cursor<NodeItem> nodeCursor, long nodeId) {
        this.id = nodeId;
        this.cursor = nodeCursor;
        this.nodeIsAddedInThisTx = this.state.nodeIsAddedInThisTx(this.id);
        return this;
    }

    public NodeItem get() {
        if (this.id == -1L) {
            throw new IllegalStateException();
        }
        return this;
    }

    public boolean next() {
        if (this.id == -1L) {
            return false;
        }
        if (this.state.nodeIsDeletedInThisTx(this.id)) {
            this.id = -1L;
            return false;
        }
        if (this.cursor.next() || this.nodeIsAddedInThisTx) {
            this.nodeIsAddedInThisTx = false;
            this.nodeState = this.state.getNodeState(this.id);
            return true;
        }
        this.id = -1L;
        this.nodeState = null;
        return false;
    }

    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.cache.accept(this);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public Cursor<LabelItem> labels() {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).labels();
        return this.state.augmentLabelCursor(cursor, this.nodeState);
    }

    @Override
    public Cursor<LabelItem> label(int labelId) {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).label(labelId);
        return this.state.augmentSingleLabelCursor(cursor, this.nodeState, labelId);
    }

    @Override
    public boolean hasLabel(int labelId) {
        return this.label(labelId).exists();
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.state.augmentPropertyCursor((Cursor<PropertyItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).properties()), this.nodeState);
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).property(propertyKeyId);
        return this.state.augmentSinglePropertyCursor(cursor, this.nodeState, propertyKeyId);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).relationships(direction, relTypes);
        return this.state.augmentNodeRelationshipCursor(cursor, this.nodeState, direction, relTypes);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction) {
        Cursor cursor = this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).relationships(direction);
        return this.state.augmentNodeRelationshipCursor(cursor, this.nodeState, direction, null);
    }

    @Override
    public Cursor<RelationshipTypeItem> relationshipTypes() {
        if (this.nodeIsAddedInThisTx) {
            return new RelationshipTypeCursor(this.nodeState.relationshipTypes());
        }
        PrimitiveIntSet types = Primitive.intSet();
        PrimitiveIntIterator typesInTx = this.nodeState.relationshipTypes();
        while (typesInTx.hasNext()) {
            types.add(typesInTx.next());
        }
        try (Cursor<RelationshipTypeItem> storeTypes = ((NodeItem)this.cursor.get()).relationshipTypes();){
            while (storeTypes.next()) {
                int current = ((RelationshipTypeItem)storeTypes.get()).getAsInt();
                if (types.contains(current) || this.degree(Direction.BOTH, current) <= 0) continue;
                types.add(current);
            }
        }
        return new RelationshipTypeCursor(types.iterator());
    }

    @Override
    public int degree(Direction direction) {
        return this.nodeState.augmentDegree(direction, this.nodeIsAddedInThisTx ? 0 : ((NodeItem)this.cursor.get()).degree(direction));
    }

    @Override
    public int degree(Direction direction, int relType) {
        int degree = this.nodeIsAddedInThisTx ? 0 : ((NodeItem)this.cursor.get()).degree(direction, relType);
        return this.nodeState.augmentDegree(direction, degree, relType);
    }

    @Override
    public Cursor<DegreeItem> degrees() {
        return new DegreeCursor(this.relationshipTypes());
    }

    @Override
    public boolean isDense() {
        return ((NodeItem)this.cursor.get()).isDense();
    }

    private class DegreeCursor
    implements Cursor<DegreeItem>,
    DegreeItem {
        private final Cursor<RelationshipTypeItem> relTypeCursor;
        private int type;
        private long outgoing;
        private long incoming;

        DegreeCursor(Cursor<RelationshipTypeItem> relTypeCursor) {
            this.relTypeCursor = relTypeCursor;
        }

        public boolean next() {
            if (this.relTypeCursor.next()) {
                this.type = ((RelationshipTypeItem)this.relTypeCursor.get()).getAsInt();
                this.outgoing = TxSingleNodeCursor.this.degree(Direction.OUTGOING, this.type);
                this.incoming = TxSingleNodeCursor.this.degree(Direction.INCOMING, this.type);
                return true;
            }
            return false;
        }

        public void close() {
            this.relTypeCursor.close();
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public long outgoing() {
            return this.outgoing;
        }

        @Override
        public long incoming() {
            return this.incoming;
        }

        public DegreeItem get() {
            return this;
        }
    }

    private class RelationshipTypeCursor
    implements Cursor<RelationshipTypeItem>,
    RelationshipTypeItem {
        private final PrimitiveIntIterator primitiveIntIterator;
        private int current = -1;

        RelationshipTypeCursor(PrimitiveIntIterator primitiveIntIterator) {
            this.primitiveIntIterator = primitiveIntIterator;
        }

        public boolean next() {
            if (this.primitiveIntIterator.hasNext()) {
                this.current = this.primitiveIntIterator.next();
                return true;
            }
            this.current = -1;
            return false;
        }

        public void close() {
        }

        @Override
        public int getAsInt() {
            return this.current;
        }

        public RelationshipTypeItem get() {
            return this;
        }
    }
}

