/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.api.schema.NodePropertyDescriptor;
import org.neo4j.kernel.api.schema.RelationshipPropertyDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class LockingStatementOperations
implements EntityWriteOperations,
SchemaReadOperations,
SchemaWriteOperations,
SchemaStateOperations,
LockOperations {
    private static final boolean SCHEMA_WRITES_DISABLE = FeatureToggles.flag(LockingStatementOperations.class, (String)"schemaWritesDisable", (boolean)false);
    private final EntityReadOperations entityReadDelegate;
    private final EntityWriteOperations entityWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;
    private final SchemaStateOperations schemaStateDelegate;

    public LockingStatementOperations(EntityReadOperations entityReadDelegate, EntityWriteOperations entityWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate, SchemaStateOperations schemaStateDelegate) {
        this.entityReadDelegate = entityReadDelegate;
        this.entityWriteDelegate = entityWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
        this.schemaStateDelegate = schemaStateDelegate;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws ConstraintValidationKernelException, EntityNotFoundException {
        this.acquireSharedSchemaLock(state);
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.indexCreate(state, descriptor);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(KernelStatement state, K key, Function<K, V> creator) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaStateDelegate.schemaStateGetOrCreate(state, key, creator);
    }

    @Override
    public <K> boolean schemaStateContains(KernelStatement state, K key) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaStateDelegate.schemaStateContains(state, key);
    }

    @Override
    public void schemaStateFlush(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        this.schemaStateDelegate.schemaStateFlush(state);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexGetForLabelAndPropertyKey(KernelStatement state, NodePropertyDescriptor descriptor) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetForLabelAndPropertyKey(state, descriptor);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexesGetAll(state);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetPopulationProgress(state, descriptor);
    }

    @Override
    public long indexSize(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexSize(state, descriptor);
    }

    @Override
    public double indexUniqueValuesPercentage(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexUniqueValuesPercentage(state, descriptor);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, Predicate<SchemaRule.Kind> filter) throws SchemaRuleNotFoundException {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.indexGetCommittedId(state, index, filter);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.uniqueIndexesGetAll(state);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        this.entityWriteDelegate.nodeDelete(state, nodeId);
    }

    @Override
    public int nodeDetachDelete(KernelStatement state, long nodeId) throws KernelException {
        MutableInt count = new MutableInt();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.entityReadDelegate, (ThrowingConsumer<Long, KernelException>)((ThrowingConsumer)relId -> {
            state.assertOpen();
            try {
                this.entityWriteDelegate.relationshipDelete(state, (long)relId);
                count.increment();
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }));
        locking.lockAllNodesAndConsumeRelationships(nodeId, state);
        state.assertOpen();
        this.entityWriteDelegate.nodeDetachDelete(state, nodeId);
        return count.intValue();
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.acquireSharedSchemaLock(state);
        this.lockRelationshipNodes(state, startNodeId, endNodeId);
        return this.entityWriteDelegate.relationshipCreate(state, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(final KernelStatement state, long relationshipId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.entityReadDelegate.relationshipVisit(state, relationshipId, new RelationshipVisitor<RuntimeException>(){

            @Override
            public void visit(long relId, int type, long startNode, long endNode) {
                LockingStatementOperations.this.lockRelationshipNodes(state, startNode, endNode);
            }
        });
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        this.entityWriteDelegate.relationshipDelete(state, relationshipId);
    }

    private void lockRelationshipNodes(KernelStatement state, long startNodeId, long endNodeId) {
        this.acquireExclusiveNodeLock(state, Math.min(startNodeId, endNodeId));
        if (startNodeId != endNodeId) {
            this.acquireExclusiveNodeLock(state, Math.max(startNodeId, endNodeId));
        }
    }

    @Override
    public UniquenessConstraint uniquePropertyConstraintCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.uniquePropertyConstraintCreate(state, descriptor);
    }

    @Override
    public NodePropertyExistenceConstraint nodePropertyExistenceConstraintCreate(KernelStatement state, NodePropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.nodePropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public RelationshipPropertyExistenceConstraint relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationshipPropertyDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        return this.schemaWriteDelegate.relationshipPropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, NodePropertyDescriptor descriptor) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, descriptor);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForLabel(state, labelId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(KernelStatement state, RelationshipPropertyDescriptor descriptor) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForRelationshipTypeAndPropertyKey(state, descriptor);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(KernelStatement state, int typeId) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForRelationshipType(state, typeId);
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll(KernelStatement state) {
        this.acquireSharedSchemaLock(state);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetAll(state);
    }

    @Override
    public void constraintDrop(KernelStatement state, NodePropertyConstraint constraint) throws DropConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public void constraintDrop(KernelStatement state, RelationshipPropertyConstraint constraint) throws DropConstraintFailureException {
        this.acquireExclusiveSchemaLock(state);
        state.assertOpen();
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws ConstraintValidationKernelException, EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireSharedSchemaLock(state);
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeSetProperty(state, nodeId, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        return this.entityWriteDelegate.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        return this.entityWriteDelegate.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        state.assertOpen();
        return this.entityWriteDelegate.graphSetProperty(state, property);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        state.assertOpen();
        return this.entityWriteDelegate.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public void acquireExclusive(KernelStatement state, ResourceType resourceType, long resourceId) {
        state.locks().pessimistic().acquireExclusive(state.lockTracer(), resourceType, resourceId);
        state.assertOpen();
    }

    @Override
    public void acquireShared(KernelStatement state, ResourceType resourceType, long resourceId) {
        state.locks().pessimistic().acquireShared(state.lockTracer(), resourceType, resourceId);
        state.assertOpen();
    }

    @Override
    public void releaseExclusive(KernelStatement state, ResourceType type, long resourceId) {
        state.locks().pessimistic().releaseExclusive(type, resourceId);
        state.assertOpen();
    }

    @Override
    public void releaseShared(KernelStatement state, ResourceType type, long resourceId) {
        state.locks().pessimistic().releaseShared(type, resourceId);
        state.assertOpen();
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }

    private void acquireExclusiveNodeLock(KernelStatement state, long nodeId) {
        if (!state.hasTxStateWithChanges() || !state.txState().nodeIsAddedInThisTx(nodeId)) {
            state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.NODE, nodeId);
        }
    }

    private void acquireExclusiveRelationshipLock(KernelStatement state, long relationshipId) {
        if (!state.hasTxStateWithChanges() || !state.txState().relationshipIsAddedInThisTx(relationshipId)) {
            state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.RELATIONSHIP, relationshipId);
        }
    }

    private void acquireSharedSchemaLock(KernelStatement state) {
        if (!SCHEMA_WRITES_DISABLE) {
            state.locks().optimistic().acquireShared(state.lockTracer(), ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        }
    }

    private void acquireExclusiveSchemaLock(KernelStatement state) {
        if (SCHEMA_WRITES_DISABLE) {
            throw new IllegalStateException("Schema modifications have been disabled via feature toggle");
        }
        state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
    }
}

