/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.schema.IndexDescriptor;

public interface CountsVisitor {
    public void visitNodeCount(int var1, long var2);

    public void visitRelationshipCount(int var1, int var2, int var3, long var4);

    public void visitIndexStatistics(IndexDescriptor var1, long var2, long var4);

    public void visitIndexSample(IndexDescriptor var1, long var2, long var4);

    public static class Adapter
    implements CountsVisitor {
        @Override
        public void visitNodeCount(int labelId, long count) {
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
        }

        @Override
        public void visitIndexStatistics(IndexDescriptor descriptor, long updates, long size) {
        }

        @Override
        public void visitIndexSample(IndexDescriptor descriptor, long unique, long size) {
        }

        public static CountsVisitor multiplex(final CountsVisitor ... visitors) {
            return new CountsVisitor(){

                @Override
                public void visitNodeCount(int labelId, long count) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitNodeCount(labelId, count);
                    }
                }

                @Override
                public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitRelationshipCount(startLabelId, typeId, endLabelId, count);
                    }
                }

                @Override
                public void visitIndexStatistics(IndexDescriptor descriptor, long updates, long size) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitIndexStatistics(descriptor, updates, size);
                    }
                }

                @Override
                public void visitIndexSample(IndexDescriptor descriptor, long unique, long size) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitIndexSample(descriptor, unique, size);
                    }
                }
            };
        }
    }

    public static interface Visitable {
        public void accept(CountsVisitor var1);
    }
}

