/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.register.Register;

public interface CountsAccessor
extends CountsVisitor.Visitable {
    public Register.DoubleLongRegister nodeCount(int var1, Register.DoubleLongRegister var2);

    public Register.DoubleLongRegister relationshipCount(int var1, int var2, int var3, Register.DoubleLongRegister var4);

    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor var1, Register.DoubleLongRegister var2);

    public Register.DoubleLongRegister indexSample(IndexDescriptor var1, Register.DoubleLongRegister var2);

    public static final class Initializer
    implements CountsVisitor {
        private final Updater updater;
        private final IndexStatsUpdater stats;

        public Initializer(Updater updater, IndexStatsUpdater stats) {
            this.updater = updater;
            this.stats = stats;
        }

        @Override
        public void visitNodeCount(int labelId, long count) {
            this.updater.incrementNodeCount(labelId, count);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            this.updater.incrementRelationshipCount(startLabelId, typeId, endLabelId, count);
        }

        @Override
        public void visitIndexStatistics(IndexDescriptor descriptor, long updates, long size) {
            this.stats.replaceIndexUpdateAndSize(descriptor, updates, size);
        }

        @Override
        public void visitIndexSample(IndexDescriptor descriptor, long unique, long size) {
            this.stats.replaceIndexSample(descriptor, unique, size);
        }
    }

    public static interface IndexStatsUpdater
    extends AutoCloseable {
        public void replaceIndexUpdateAndSize(IndexDescriptor var1, long var2, long var4);

        public void replaceIndexSample(IndexDescriptor var1, long var2, long var4);

        public void incrementIndexUpdates(IndexDescriptor var1, long var2);

        @Override
        public void close();
    }

    public static interface Updater
    extends AutoCloseable {
        public void incrementNodeCount(int var1, long var2);

        public void incrementRelationshipCount(int var1, int var2, int var3, long var4);

        @Override
        public void close();
    }
}

