/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension.dependency;

import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.extension.dependency.HighestSelectionStrategy;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;

public class HighestPrioritizedLabelScanStore
implements DependencyResolver.SelectionStrategy {
    private final String specificallyConfigured;

    public HighestPrioritizedLabelScanStore(String specificallyConfigured) {
        this.specificallyConfigured = specificallyConfigured;
    }

    public <T> T select(Class<T> type, Iterable<T> candidates) throws IllegalArgumentException {
        if (!type.equals(LabelScanStoreProvider.class)) {
            throw new IllegalArgumentException("Was expecting " + LabelScanStoreProvider.class);
        }
        if (this.specificallyConfigured != null) {
            Iterable filtered = Iterables.filter(item -> HighestPrioritizedLabelScanStore.nameOf(item).equals(this.specificallyConfigured), candidates);
            Object specificItem = Iterables.single((Iterable)filtered, null);
            if (specificItem == null) {
                throw new IllegalArgumentException("Configured label scan store '" + this.specificallyConfigured + "', but couldn't find it among candidates " + HighestPrioritizedLabelScanStore.candidateNames(candidates));
            }
            return (T)specificItem;
        }
        return (T)HighestSelectionStrategy.getInstance().select(type, candidates);
    }

    private static String candidateNames(Iterable<?> candidates) {
        StringBuilder builder = new StringBuilder("[");
        int i = 0;
        for (Object candidate : candidates) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(HighestPrioritizedLabelScanStore.nameOf(candidate));
            ++i;
        }
        return builder.append("]").toString();
    }

    private static String nameOf(Object candidate) {
        return ((LabelScanStoreProvider)candidate).getName();
    }
}

