/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.schema.IndexDescriptor;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class SchemaProcedure {
    private final GraphDatabaseAPI graphDatabaseAPI;
    private final KernelTransaction kernelTransaction;

    public SchemaProcedure(GraphDatabaseAPI graphDatabaseAPI, KernelTransaction kernelTransaction) {
        this.graphDatabaseAPI = graphDatabaseAPI;
        this.kernelTransaction = kernelTransaction;
    }

    public GraphResult buildSchemaGraph() {
        HashMap<String, NodeImpl> nodes = new HashMap<String, NodeImpl>();
        HashMap<String, Set<RelationshipImpl>> relationships = new HashMap<String, Set<RelationshipImpl>>();
        ReadOperations readOperations = this.kernelTransaction.acquireStatement().readOperations();
        StatementTokenNameLookup statementTokenNameLookup = new StatementTokenNameLookup(readOperations);
        try (Transaction transaction = this.graphDatabaseAPI.beginTx();){
            for (Label label : this.graphDatabaseAPI.getAllLabelsInUse()) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Iterator<IndexDescriptor> indexDescriptorIterator = readOperations.indexesGetForLabel(readOperations.labelGetForName(label.name()));
                ArrayList<String> indexes = new ArrayList<String>();
                while (indexDescriptorIterator.hasNext()) {
                    IndexDescriptor index = indexDescriptorIterator.next();
                    CharSequence[] propertyNames = PropertyNameUtils.getPropertyKeys(statementTokenNameLookup, index.descriptor());
                    indexes.add(String.join((CharSequence)",", propertyNames));
                }
                properties.put("indexes", indexes);
                Iterator<NodePropertyConstraint> nodePropertyConstraintIterator = readOperations.constraintsGetForLabel(readOperations.labelGetForName(label.name()));
                ArrayList<String> constraints = new ArrayList<String>();
                while (nodePropertyConstraintIterator.hasNext()) {
                    constraints.add(nodePropertyConstraintIterator.next().userDescription(statementTokenNameLookup));
                }
                properties.put("constraints", constraints);
                this.getOrCreateLabel(label.name(), properties, nodes);
            }
            for (RelationshipType relationshipType : this.graphDatabaseAPI.getAllRelationshipTypesInUse()) {
                String relationshipTypeGetName = relationshipType.name();
                int relId = readOperations.relationshipTypeGetForName(relationshipTypeGetName);
                ResourceIterator labelsInUse = this.graphDatabaseAPI.getAllLabelsInUse().iterator();
                LinkedList<NodeImpl> startNodes = new LinkedList<NodeImpl>();
                LinkedList<NodeImpl> endNodes = new LinkedList<NodeImpl>();
                while (labelsInUse.hasNext()) {
                    Label labelToken = (Label)labelsInUse.next();
                    String labelName = labelToken.name();
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    NodeImpl node = this.getOrCreateLabel(labelName, properties, nodes);
                    int labelId = readOperations.labelGetForName(labelName);
                    if (readOperations.countsForRelationship(labelId, relId, -1) > 0L) {
                        startNodes.add(node);
                    }
                    if (readOperations.countsForRelationship(-1, relId, labelId) <= 0L) continue;
                    endNodes.add(node);
                }
                for (NodeImpl startNode : startNodes) {
                    for (NodeImpl endNode : endNodes) {
                        RelationshipImpl relationshipImpl = this.addRelationship(startNode, endNode, relationshipTypeGetName, relationships);
                    }
                }
            }
            transaction.success();
            GraphResult graphResult = this.getGraphResult(nodes, relationships);
            return graphResult;
        }
    }

    private NodeImpl getOrCreateLabel(String label, Map<String, Object> properties, Map<String, NodeImpl> nodeMap) {
        if (nodeMap.containsKey(label)) {
            return nodeMap.get(label);
        }
        NodeImpl node = new NodeImpl(label, properties);
        nodeMap.put(label, node);
        return node;
    }

    private RelationshipImpl addRelationship(NodeImpl startNode, NodeImpl endNode, String relType, Map<String, Set<RelationshipImpl>> relationshipMap) {
        Set<Object> relationshipsForType;
        if (!relationshipMap.containsKey(relType)) {
            relationshipsForType = new HashSet();
            relationshipMap.put(relType, relationshipsForType);
        } else {
            relationshipsForType = relationshipMap.get(relType);
        }
        RelationshipImpl relationship = new RelationshipImpl(startNode, endNode, relType);
        if (!relationshipsForType.contains(relationship)) {
            relationshipsForType.add(relationship);
        }
        return relationship;
    }

    private GraphResult getGraphResult(Map<String, NodeImpl> nodeMap, Map<String, Set<RelationshipImpl>> relationshipMap) {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        for (Set<RelationshipImpl> relationship : relationshipMap.values()) {
            relationships.addAll(relationship);
        }
        GraphResult graphResult = new GraphResult(new ArrayList<Node>(nodeMap.values()), relationships);
        return graphResult;
    }

    private static class NodeImpl
    implements Node {
        private final HashMap<String, Object> propertyMap = new HashMap();
        private static AtomicLong MIN_ID = new AtomicLong(-1L);
        private final long id = MIN_ID.getAndDecrement();
        private final Label label;

        public NodeImpl(String label, Map<String, Object> properties) {
            this.label = Label.label((String)label);
            this.propertyMap.putAll(properties);
            this.propertyMap.put("name", label);
        }

        public long getId() {
            return this.id;
        }

        public Map<String, Object> getAllProperties() {
            return this.propertyMap;
        }

        public Iterable<Label> getLabels() {
            return Arrays.asList(this.label);
        }

        public void delete() {
        }

        public Iterable<Relationship> getRelationships() {
            return null;
        }

        public boolean hasRelationship() {
            return false;
        }

        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            return null;
        }

        public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            return null;
        }

        public Iterable<Relationship> getRelationships(RelationshipType type, Direction direction) {
            return null;
        }

        public Iterable<Relationship> getRelationships(Direction direction) {
            return null;
        }

        public boolean hasRelationship(RelationshipType ... types) {
            return false;
        }

        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            return false;
        }

        public boolean hasRelationship(RelationshipType type, Direction direction) {
            return false;
        }

        public boolean hasRelationship(Direction direction) {
            return false;
        }

        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            return null;
        }

        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            return null;
        }

        public Iterable<RelationshipType> getRelationshipTypes() {
            return null;
        }

        public int getDegree() {
            return 0;
        }

        public int getDegree(RelationshipType type) {
            return 0;
        }

        public int getDegree(RelationshipType type, Direction direction) {
            return 0;
        }

        public int getDegree(Direction direction) {
            return 0;
        }

        public void addLabel(Label label) {
        }

        public void removeLabel(Label label) {
        }

        public boolean hasLabel(Label label) {
            return false;
        }

        public GraphDatabaseService getGraphDatabase() {
            return null;
        }

        public boolean hasProperty(String key) {
            return false;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Object getProperty(String key, Object defaultValue) {
            return null;
        }

        public void setProperty(String key, Object value) {
        }

        public Object removeProperty(String key) {
            return null;
        }

        public Iterable<String> getPropertyKeys() {
            return null;
        }

        public Map<String, Object> getProperties(String ... keys) {
            return null;
        }
    }

    private static class RelationshipImpl
    implements Relationship {
        private static AtomicLong MIN_ID = new AtomicLong(-1L);
        private final long id = MIN_ID.getAndDecrement();
        private final Node startNode;
        private final Node endNode;
        private final RelationshipType relationshipType;

        public RelationshipImpl(NodeImpl startNode, NodeImpl endNode, final String type) {
            this.startNode = startNode;
            this.endNode = endNode;
            this.relationshipType = new RelationshipType(){

                public String name() {
                    return type;
                }
            };
        }

        public long getId() {
            return this.id;
        }

        public Node getStartNode() {
            return this.startNode;
        }

        public Node getEndNode() {
            return this.endNode;
        }

        public RelationshipType getType() {
            return this.relationshipType;
        }

        public Map<String, Object> getAllProperties() {
            return new HashMap<String, Object>();
        }

        public void delete() {
        }

        public Node getOtherNode(Node node) {
            return null;
        }

        public Node[] getNodes() {
            return new Node[0];
        }

        public boolean isType(RelationshipType type) {
            return false;
        }

        public GraphDatabaseService getGraphDatabase() {
            return null;
        }

        public boolean hasProperty(String key) {
            return false;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Object getProperty(String key, Object defaultValue) {
            return null;
        }

        public void setProperty(String key, Object value) {
        }

        public Object removeProperty(String key) {
            return null;
        }

        public Iterable<String> getPropertyKeys() {
            return null;
        }

        public Map<String, Object> getProperties(String ... keys) {
            return null;
        }
    }

    public static class GraphResult {
        public final List<Node> nodes;
        public final List<Relationship> relationships;

        public GraphResult(List<Node> nodes, List<Relationship> relationships) {
            this.nodes = nodes;
            this.relationships = relationships;
        }
    }
}

