/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.kernel.impl.api.store.HighIdAwareIterator;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class AllRecordIdIterator<RECORD extends PrimitiveRecord, STORE extends CommonAbstractStore<RECORD, ?>>
extends HighIdAwareIterator<STORE> {
    protected final RECORD record;
    private long currentId;

    AllRecordIdIterator(RECORD record, STORE store) {
        super(store);
        this.record = record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doFetchNext(long highId) {
        while (this.currentId <= highId) {
            try {
                this.store.getRecord(this.currentId, this.record, RecordLoad.CHECK);
                if (!((AbstractBaseRecord)this.record).inUse()) continue;
                boolean bl = this.next(((AbstractBaseRecord)this.record).getId());
                return bl;
            }
            finally {
                ++this.currentId;
            }
        }
        return false;
    }
}

