/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.function.Consumer;
import java.util.function.IntSupplier;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.cursor.GenericCursor;
import org.neo4j.cursor.IntValue;
import org.neo4j.kernel.api.cursor.NodeItemHelper;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.storageengine.api.DegreeItem;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.txstate.NodeState;

public abstract class TxAbstractNodeCursor
extends NodeItemHelper
implements Cursor<NodeItem> {
    protected final TransactionState state;
    private final Consumer<TxAbstractNodeCursor> cache;
    protected Cursor<NodeItem> cursor;
    protected long id = -1L;
    protected NodeState nodeState;
    protected boolean nodeIsAddedInThisTx;

    public TxAbstractNodeCursor(TransactionState state, Consumer<TxAbstractNodeCursor> cache) {
        this.state = state;
        this.cache = cache;
    }

    public TxAbstractNodeCursor init(Cursor<NodeItem> nodeCursor) {
        this.cursor = nodeCursor;
        return this;
    }

    public NodeItem get() {
        if (this.id == -1L) {
            throw new IllegalStateException();
        }
        return this;
    }

    public void close() {
        this.cursor.close();
        this.cursor = null;
        this.cache.accept(this);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public Cursor<LabelItem> labels() {
        return this.state.augmentLabelCursor((Cursor<LabelItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).labels()), this.nodeState);
    }

    @Override
    public Cursor<LabelItem> label(int labelId) {
        return this.state.augmentSingleLabelCursor((Cursor<LabelItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).label(labelId)), this.nodeState, labelId);
    }

    @Override
    public Cursor<PropertyItem> properties() {
        return this.state.augmentPropertyCursor((Cursor<PropertyItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).properties()), this.nodeState);
    }

    @Override
    public Cursor<PropertyItem> property(int propertyKeyId) {
        return this.state.augmentSinglePropertyCursor((Cursor<PropertyItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).property(propertyKeyId)), this.nodeState, propertyKeyId);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction, int ... relTypes) {
        return this.state.augmentNodeRelationshipCursor((Cursor<RelationshipItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).relationships(direction, relTypes)), this.nodeState, direction, relTypes);
    }

    @Override
    public Cursor<RelationshipItem> relationships(Direction direction) {
        return this.state.augmentNodeRelationshipCursor((Cursor<RelationshipItem>)(this.nodeIsAddedInThisTx ? Cursors.empty() : ((NodeItem)this.cursor.get()).relationships(direction)), this.nodeState, direction, null);
    }

    @Override
    public Cursor<IntSupplier> relationshipTypes() {
        if (this.nodeIsAddedInThisTx) {
            return new RelationshipTypeCursor(this.nodeState.relationshipTypes());
        }
        PrimitiveIntSet types = Primitive.intSet();
        PrimitiveIntIterator typesInTx = this.nodeState.relationshipTypes();
        while (typesInTx.hasNext()) {
            types.add(typesInTx.next());
        }
        try (Cursor<IntSupplier> storeTypes = ((NodeItem)this.cursor.get()).relationshipTypes();){
            while (storeTypes.next()) {
                int current = ((IntSupplier)storeTypes.get()).getAsInt();
                if (types.contains(current) || this.degree(Direction.BOTH, current) <= 0) continue;
                types.add(current);
            }
        }
        return new RelationshipTypeCursor(types.iterator());
    }

    @Override
    public int degree(Direction direction) {
        return this.nodeState.augmentDegree(direction, this.nodeIsAddedInThisTx ? 0 : ((NodeItem)this.cursor.get()).degree(direction));
    }

    @Override
    public int degree(Direction direction, int relType) {
        return this.nodeState.augmentDegree(direction, this.nodeIsAddedInThisTx ? 0 : ((NodeItem)this.cursor.get()).degree(direction, relType), relType);
    }

    @Override
    public Cursor<DegreeItem> degrees() {
        return new DegreeCursor(this.relationshipTypes());
    }

    @Override
    public boolean isDense() {
        return ((NodeItem)this.cursor.get()).isDense();
    }

    private class DegreeCursor
    implements Cursor<DegreeItem>,
    DegreeItem {
        private final Cursor<IntSupplier> relTypeCursor;
        private int type;
        private long outgoing;
        private long incoming;

        public DegreeCursor(Cursor<IntSupplier> relTypeCursor) {
            this.relTypeCursor = relTypeCursor;
        }

        public boolean next() {
            if (this.relTypeCursor.next()) {
                this.type = ((IntSupplier)this.relTypeCursor.get()).getAsInt();
                this.outgoing = TxAbstractNodeCursor.this.degree(Direction.OUTGOING, this.type);
                this.incoming = TxAbstractNodeCursor.this.degree(Direction.INCOMING, this.type);
                return true;
            }
            return false;
        }

        public void close() {
            this.relTypeCursor.close();
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public long outgoing() {
            return this.outgoing;
        }

        @Override
        public long incoming() {
            return this.incoming;
        }

        public DegreeItem get() {
            return this;
        }
    }

    private class RelationshipTypeCursor
    extends GenericCursor<IntSupplier> {
        private final PrimitiveIntIterator primitiveIntIterator;

        public RelationshipTypeCursor(PrimitiveIntIterator primitiveIntIterator) {
            this.primitiveIntIterator = primitiveIntIterator;
            this.current = new IntValue();
        }

        public boolean next() {
            if (this.primitiveIntIterator.hasNext()) {
                ((IntValue)this.current).setValue(this.primitiveIntIterator.next());
                return true;
            }
            this.current = null;
            return false;
        }
    }
}

