/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.logging.Log;

public class ServerConfigurationValidator
implements ConfigurationValidator {
    @Override
    @Nonnull
    public Map<String, String> validate(@Nonnull Collection<SettingValidator> settingValidators, @Nonnull Map<String, String> rawConfig, @Nonnull Log log) throws InvalidSettingException {
        Pattern pattern = Pattern.compile(Pattern.quote("dbms.connector.") + "([^\\.]+)\\.(.+)");
        List connectors = rawConfig.keySet().stream().map(pattern::matcher).filter(Matcher::matches).map(match -> match.group(1)).distinct().map(Connector::new).collect(Collectors.toList());
        HashMap<String, String> validSettings = new HashMap<String, String>(rawConfig);
        connectors.stream().filter(connector -> connector.type.apply(rawConfig::get) == null).forEach(connector -> {
            if ("http".equalsIgnoreCase(connector.group.groupKey) || "https".equalsIgnoreCase(connector.group.groupKey)) {
                validSettings.put(connector.type.name(), Connector.ConnectorType.HTTP.name());
            } else {
                validSettings.put(connector.type.name(), Connector.ConnectorType.BOLT.name());
            }
        });
        if (connectors.stream().filter(connector -> ((Connector.ConnectorType)((Object)((Object)connector.type.apply(validSettings::get)))).equals((Object)Connector.ConnectorType.HTTP)).noneMatch(connector -> (Boolean)connector.enabled.apply(validSettings::get))) {
            throw new InvalidSettingException(String.format("Missing mandatory enabled connector of type '%s'", new Object[]{Connector.ConnectorType.HTTP}));
        }
        return validSettings;
    }
}

