/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ExecutingQuery;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.ProcedureCallOperations;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateIndexSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexSchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.operations.CountsOperations;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.KeyReadOperations;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexReadOperations;
import org.neo4j.kernel.impl.api.operations.LegacyIndexWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.QuerySource;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class OperationsFacade
implements ReadOperations,
DataWriteOperations,
org.neo4j.kernel.api.SchemaWriteOperations,
QueryRegistryOperations,
ProcedureCallOperations {
    private final KernelTransaction tx;
    private final KernelStatement statement;
    private final Procedures procedures;
    private StatementOperationParts operations;

    OperationsFacade(KernelTransaction tx, KernelStatement statement, Procedures procedures) {
        this.tx = tx;
        this.statement = statement;
        this.procedures = procedures;
    }

    public void initialize(StatementOperationParts operationParts) {
        this.operations = operationParts;
    }

    final KeyReadOperations tokenRead() {
        return this.operations.keyReadOperations();
    }

    final KeyWriteOperations tokenWrite() {
        return this.operations.keyWriteOperations();
    }

    final EntityReadOperations dataRead() {
        return this.operations.entityReadOperations();
    }

    final EntityWriteOperations dataWrite() {
        return this.operations.entityWriteOperations();
    }

    final LegacyIndexWriteOperations legacyIndexWrite() {
        return this.operations.legacyIndexWriteOperations();
    }

    final LegacyIndexReadOperations legacyIndexRead() {
        return this.operations.legacyIndexReadOperations();
    }

    final SchemaReadOperations schemaRead() {
        return this.operations.schemaReadOperations();
    }

    final SchemaWriteOperations schemaWrite() {
        return this.operations.schemaWriteOperations();
    }

    final QueryRegistrationOperations queryRegistrationOperations() {
        return this.operations.queryRegistrationOperations();
    }

    final SchemaStateOperations schemaState() {
        return this.operations.schemaStateOperations();
    }

    final LockOperations locking() {
        return this.operations.locking();
    }

    final CountsOperations counting() {
        return this.operations.counting();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        this.statement.assertOpen();
        return this.dataRead().nodesGetAll(this.statement);
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll() {
        this.statement.assertOpen();
        return this.dataRead().relationshipsGetAll(this.statement);
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(int labelId) {
        this.statement.assertOpen();
        if (labelId == -1) {
            return PrimitiveLongCollections.emptyIterator();
        }
        return this.dataRead().nodesGetForLabel(this.statement, labelId);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexSeek(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexSeek(this.statement, index, value);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByNumber(IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexRangeSeekByNumber(this.statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByString(IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexRangeSeekByString(this.statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexRangeSeekByPrefix(IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexRangeSeekByPrefix(this.statement, index, prefix);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexScan(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexScan(this.statement, index);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexContainsScan(IndexDescriptor index, String term) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexContainsScan(this.statement, index, term);
    }

    @Override
    public PrimitiveLongIterator nodesGetFromIndexEndsWithScan(IndexDescriptor index, String suffix) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesGetFromIndexEndsWithScan(this.statement, index, suffix);
    }

    @Override
    public long nodeGetFromUniqueIndexSeek(IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeGetFromUniqueIndexSeek(this.statement, index, value);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        this.statement.assertOpen();
        return this.dataRead().nodeExists(this.statement, nodeId);
    }

    @Override
    public boolean relationshipExists(long relId) {
        this.statement.assertOpen();
        try (Cursor<RelationshipItem> cursor = this.relationshipCursor(relId);){
            boolean bl = cursor.next();
            return bl;
        }
    }

    @Override
    public boolean nodeHasLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (labelId == -1) {
            return false;
        }
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            boolean bl = ((NodeItem)node.get()).hasLabel(labelId);
            return bl;
        }
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            PrimitiveIntIterator primitiveIntIterator = ((NodeItem)node.get()).getLabels();
            return primitiveIntIterator;
        }
    }

    @Override
    public boolean nodeHasProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return false;
        }
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            boolean bl = ((NodeItem)node.get()).hasProperty(propertyKeyId);
            return bl;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object nodeGetProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return null;
        }
        try {
            try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
                Object object = ((NodeItem)node.get()).getProperty(propertyKeyId);
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.statement.assertOpen();
        }
    }

    @Override
    public RelationshipIterator nodeGetRelationships(long nodeId, Direction direction, int ... relTypes) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            RelationshipIterator relationshipIterator = ((NodeItem)node.get()).getRelationships(this.direction(direction), relTypes);
            return relationshipIterator;
        }
    }

    private org.neo4j.storageengine.api.Direction direction(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return org.neo4j.storageengine.api.Direction.OUTGOING;
            }
            case INCOMING: {
                return org.neo4j.storageengine.api.Direction.INCOMING;
            }
            case BOTH: {
                return org.neo4j.storageengine.api.Direction.BOTH;
            }
        }
        throw new IllegalArgumentException(direction.name());
    }

    @Override
    public RelationshipIterator nodeGetRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            RelationshipIterator relationshipIterator = ((NodeItem)node.get()).getRelationships(this.direction(direction));
            return relationshipIterator;
        }
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            int n = ((NodeItem)node.get()).degree(this.direction(direction), relType);
            return n;
        }
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            int n = ((NodeItem)node.get()).degree(this.direction(direction));
            return n;
        }
    }

    @Override
    public boolean nodeIsDense(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            boolean bl = ((NodeItem)node.get()).isDense();
            return bl;
        }
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
            PrimitiveIntIterator primitiveIntIterator = ((NodeItem)node.get()).getRelationshipTypes();
            return primitiveIntIterator;
        }
    }

    @Override
    public boolean relationshipHasProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return false;
        }
        try (Cursor<RelationshipItem> relationship = this.dataRead().relationshipCursorById(this.statement, relationshipId);){
            boolean bl = ((RelationshipItem)relationship.get()).hasProperty(propertyKeyId);
            return bl;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object relationshipGetProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return null;
        }
        try {
            try (Cursor<RelationshipItem> relationship = this.dataRead().relationshipCursorById(this.statement, relationshipId);){
                Object object = ((RelationshipItem)relationship.get()).getProperty(propertyKeyId);
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.statement.assertOpen();
        }
    }

    @Override
    public boolean graphHasProperty(int propertyKeyId) {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return false;
        }
        return this.dataRead().graphHasProperty(this.statement, propertyKeyId);
    }

    @Override
    public Object graphGetProperty(int propertyKeyId) {
        this.statement.assertOpen();
        if (propertyKeyId == -1) {
            return null;
        }
        return this.dataRead().graphGetProperty(this.statement, propertyKeyId);
    }

    /*
     * Loose catch block
     */
    @Override
    public PrimitiveIntIterator nodeGetPropertyKeys(long nodeId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try {
            try (Cursor<NodeItem> node = this.dataRead().nodeCursorById(this.statement, nodeId);){
                PrimitiveIntCollection propertyKeys = ((NodeItem)node.get()).getPropertyKeys();
                PrimitiveIntIterator primitiveIntIterator = propertyKeys.iterator();
                return primitiveIntIterator;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.statement.assertOpen();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public PrimitiveIntIterator relationshipGetPropertyKeys(long relationshipId) throws EntityNotFoundException {
        this.statement.assertOpen();
        try {
            try (Cursor<RelationshipItem> relationship = this.dataRead().relationshipCursorById(this.statement, relationshipId);){
                PrimitiveIntCollection propertyKeys = ((RelationshipItem)relationship.get()).getPropertyKeys();
                PrimitiveIntIterator primitiveIntIterator = propertyKeys.iterator();
                return primitiveIntIterator;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.statement.assertOpen();
        }
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys() {
        this.statement.assertOpen();
        return this.dataRead().graphGetPropertyKeys(this.statement);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relId, RelationshipVisitor<EXCEPTION> visitor) throws EntityNotFoundException, EXCEPTION {
        this.statement.assertOpen();
        this.dataRead().relationshipVisit(this.statement, relId, visitor);
    }

    @Override
    public long nodesGetCount() {
        this.statement.assertOpen();
        return this.dataRead().nodesGetCount(this.statement);
    }

    @Override
    public long relationshipsGetCount() {
        this.statement.assertOpen();
        return this.dataRead().relationshipsGetCount(this.statement);
    }

    @Override
    public ProcedureSignature procedureGet(QualifiedName name) throws ProcedureException {
        this.statement.assertOpen();
        return this.procedures.procedure(name);
    }

    @Override
    public Optional<UserFunctionSignature> functionGet(QualifiedName name) {
        this.statement.assertOpen();
        return this.procedures.function(name);
    }

    @Override
    public Set<UserFunctionSignature> functionsGetAll() {
        this.statement.assertOpen();
        return this.procedures.getAllFunctions();
    }

    @Override
    public Set<ProcedureSignature> proceduresGetAll() {
        this.statement.assertOpen();
        return this.procedures.getAllProcedures();
    }

    @Override
    public Cursor<NodeItem> nodeCursor(long nodeId) {
        this.statement.assertOpen();
        return this.dataRead().nodeCursor(this.statement, nodeId);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursor(long relId) {
        this.statement.assertOpen();
        return this.dataRead().relationshipCursor(this.statement, relId);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetAll() {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetAll(this.statement);
    }

    @Override
    public Cursor<RelationshipItem> relationshipCursorGetAll() {
        this.statement.assertOpen();
        return this.dataRead().relationshipCursorGetAll(this.statement);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetForLabel(this.statement, labelId);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexSeek(IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetFromIndexSeek(this.statement, index, value);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexScan(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetFromIndexScan(this.statement, index);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByNumber(IndexDescriptor index, Number lower, boolean includeLower, Number upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetFromIndexRangeSeekByNumber(this.statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByString(IndexDescriptor index, String lower, boolean includeLower, String upper, boolean includeUpper) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetFromIndexRangeSeekByString(this.statement, index, lower, includeLower, upper, includeUpper);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromIndexRangeSeekByPrefix(IndexDescriptor index, String prefix) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetFromIndexRangeSeekByPrefix(this.statement, index, prefix);
    }

    @Override
    public Cursor<NodeItem> nodeCursorGetFromUniqueIndexSeek(IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodeCursorGetFromUniqueIndexSeek(this.statement, index, value);
    }

    @Override
    public long nodesCountIndexed(IndexDescriptor index, long nodeId, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        this.statement.assertOpen();
        return this.dataRead().nodesCountIndexed(this.statement, index, nodeId, value);
    }

    @Override
    public IndexDescriptor indexGetForLabelAndPropertyKey(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException {
        this.statement.assertOpen();
        IndexDescriptor descriptor = this.schemaRead().indexGetForLabelAndPropertyKey(this.statement, labelId, propertyKeyId);
        if (descriptor == null) {
            throw new IndexSchemaRuleNotFoundException(labelId, propertyKeyId);
        }
        return descriptor;
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().indexesGetAll(this.statement);
    }

    @Override
    public IndexDescriptor uniqueIndexGetForLabelAndPropertyKey(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException, DuplicateIndexSchemaRuleException {
        IndexDescriptor result = null;
        Iterator<IndexDescriptor> indexes = this.uniqueIndexesGetForLabel(labelId);
        while (indexes.hasNext()) {
            IndexDescriptor index = indexes.next();
            if (index.getPropertyKeyId() != propertyKeyId) continue;
            if (null == result) {
                result = index;
                continue;
            }
            throw new DuplicateIndexSchemaRuleException(labelId, propertyKeyId, true);
        }
        if (null == result) {
            throw new IndexSchemaRuleNotFoundException(labelId, propertyKeyId, true);
        }
        return result;
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().uniqueIndexesGetForLabel(this.statement, labelId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetOwningUniquenessConstraintId(this.statement, index);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().uniqueIndexesGetAll(this.statement);
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetState(this.statement, descriptor);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetPopulationProgress(this.statement, descriptor);
    }

    @Override
    public long indexSize(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexSize(this.statement, descriptor);
    }

    @Override
    public double indexUniqueValuesSelectivity(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexUniqueValuesPercentage(this.statement, descriptor);
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.schemaRead().indexGetFailure(this.statement, descriptor);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabelAndPropertyKey(int labelId, int propertyKeyId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForLabelAndPropertyKey(this.statement, labelId, propertyKeyId);
    }

    @Override
    public Iterator<NodePropertyConstraint> constraintsGetForLabel(int labelId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForLabel(this.statement, labelId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipType(int typeId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForRelationshipType(this.statement, typeId);
    }

    @Override
    public Iterator<RelationshipPropertyConstraint> constraintsGetForRelationshipTypeAndPropertyKey(int typeId, int propertyKeyId) {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetForRelationshipTypeAndPropertyKey(this.statement, typeId, propertyKeyId);
    }

    @Override
    public Iterator<PropertyConstraint> constraintsGetAll() {
        this.statement.assertOpen();
        return this.schemaRead().constraintsGetAll(this.statement);
    }

    @Override
    public int labelGetForName(String labelName) {
        this.statement.assertOpen();
        return this.tokenRead().labelGetForName(this.statement, labelName);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().labelGetName(this.statement, labelId);
    }

    @Override
    public int propertyKeyGetForName(String propertyKeyName) {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetForName(this.statement, propertyKeyName);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetName(this.statement, propertyKeyId);
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyGetAllTokens(this.statement);
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().labelsGetAllTokens(this.statement);
    }

    @Override
    public Iterator<Token> relationshipTypesGetAllTokens() {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypesGetAllTokens(this.statement);
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetForName(this.statement, relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeGetName(this.statement, relationshipTypeId);
    }

    @Override
    public int labelCount() {
        this.statement.assertOpen();
        return this.tokenRead().labelCount(this.statement);
    }

    @Override
    public int propertyKeyCount() {
        this.statement.assertOpen();
        return this.tokenRead().propertyKeyCount(this.statement);
    }

    @Override
    public int relationshipTypeCount() {
        this.statement.assertOpen();
        return this.tokenRead().relationshipTypeCount(this.statement);
    }

    @Override
    public int labelGetOrCreateForName(String labelName) throws IllegalTokenNameException, TooManyLabelsException {
        this.statement.assertOpen();
        return this.tokenWrite().labelGetOrCreateForName(this.statement, labelName);
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKeyName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        return this.tokenWrite().propertyKeyGetOrCreateForName(this.statement, propertyKeyName);
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) throws IllegalTokenNameException {
        this.statement.assertOpen();
        return this.tokenWrite().relationshipTypeGetOrCreateForName(this.statement, relationshipTypeName);
    }

    @Override
    public void labelCreateForName(String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        this.statement.assertOpen();
        this.tokenWrite().labelCreateForName(this.statement, labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(String propertyKeyName, int id) throws IllegalTokenNameException {
        this.statement.assertOpen();
        this.tokenWrite().propertyKeyCreateForName(this.statement, propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(String relationshipTypeName, int id) throws IllegalTokenNameException {
        this.statement.assertOpen();
        this.tokenWrite().relationshipTypeCreateForName(this.statement, relationshipTypeName, id);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return this.schemaState().schemaStateGetOrCreate(this.statement, key, creator);
    }

    @Override
    public void schemaStateFlush() {
        this.schemaState().schemaStateFlush(this.statement);
    }

    @Override
    public long nodeCreate() {
        this.statement.assertOpen();
        return this.dataWrite().nodeCreate(this.statement);
    }

    @Override
    public void nodeDelete(long nodeId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        this.statement.assertOpen();
        this.dataWrite().nodeDelete(this.statement, nodeId);
    }

    @Override
    public int nodeDetachDelete(long nodeId) throws KernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeDetachDelete(this.statement, nodeId);
    }

    @Override
    public long relationshipCreate(int relationshipTypeId, long startNodeId, long endNodeId) throws RelationshipTypeIdNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipCreate(this.statement, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(long relationshipId) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException {
        this.statement.assertOpen();
        this.dataWrite().relationshipDelete(this.statement, relationshipId);
    }

    @Override
    public boolean nodeAddLabel(long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeAddLabel(this.statement, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(long nodeId, int labelId) throws EntityNotFoundException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveLabel(this.statement, nodeId, labelId);
    }

    @Override
    public Property nodeSetProperty(long nodeId, DefinedProperty property) throws EntityNotFoundException, ConstraintValidationKernelException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeSetProperty(this.statement, nodeId, property);
    }

    @Override
    public Property relationshipSetProperty(long relationshipId, DefinedProperty property) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipSetProperty(this.statement, relationshipId, property);
    }

    @Override
    public Property graphSetProperty(DefinedProperty property) {
        this.statement.assertOpen();
        return this.dataWrite().graphSetProperty(this.statement, property);
    }

    @Override
    public Property nodeRemoveProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.statement.assertOpen();
        return this.dataWrite().nodeRemoveProperty(this.statement, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipRemoveProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.statement.assertOpen();
        return this.dataWrite().relationshipRemoveProperty(this.statement, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphRemoveProperty(int propertyKeyId) {
        this.statement.assertOpen();
        return this.dataWrite().graphRemoveProperty(this.statement, propertyKeyId);
    }

    @Override
    public IndexDescriptor indexCreate(int labelId, int propertyKeyId) throws AlreadyIndexedException, AlreadyConstrainedException {
        this.statement.assertOpen();
        return this.schemaWrite().indexCreate(this.statement, labelId, propertyKeyId);
    }

    @Override
    public void indexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.statement.assertOpen();
        this.schemaWrite().indexDrop(this.statement, descriptor);
    }

    @Override
    public UniquenessConstraint uniquePropertyConstraintCreate(int labelId, int propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException {
        this.statement.assertOpen();
        return this.schemaWrite().uniquePropertyConstraintCreate(this.statement, labelId, propertyKeyId);
    }

    @Override
    public NodePropertyExistenceConstraint nodePropertyExistenceConstraintCreate(int labelId, int propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException {
        this.statement.assertOpen();
        return this.schemaWrite().nodePropertyExistenceConstraintCreate(this.statement, labelId, propertyKeyId);
    }

    @Override
    public RelationshipPropertyExistenceConstraint relationshipPropertyExistenceConstraintCreate(int relTypeId, int propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException {
        this.statement.assertOpen();
        return this.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.statement, relTypeId, propertyKeyId);
    }

    @Override
    public void constraintDrop(NodePropertyConstraint constraint) throws DropConstraintFailureException {
        this.statement.assertOpen();
        this.schemaWrite().constraintDrop(this.statement, constraint);
    }

    @Override
    public void constraintDrop(RelationshipPropertyConstraint constraint) throws DropConstraintFailureException {
        this.statement.assertOpen();
        this.schemaWrite().constraintDrop(this.statement, constraint);
    }

    @Override
    public void uniqueIndexDrop(IndexDescriptor descriptor) throws DropIndexFailureException {
        this.statement.assertOpen();
        this.schemaWrite().uniqueIndexDrop(this.statement, descriptor);
    }

    @Override
    public void acquireExclusive(ResourceType type, long id) {
        this.statement.assertOpen();
        this.locking().acquireExclusive(this.statement, type, id);
    }

    @Override
    public void acquireShared(ResourceType type, long id) {
        this.statement.assertOpen();
        this.locking().acquireShared(this.statement, type, id);
    }

    @Override
    public void releaseExclusive(ResourceType type, long id) {
        this.statement.assertOpen();
        this.locking().releaseExclusive(this.statement, type, id);
    }

    @Override
    public void releaseShared(ResourceType type, long id) {
        this.statement.assertOpen();
        this.locking().releaseShared(this.statement, type, id);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexGet(String indexName, String key, Object value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexGet(this.statement, indexName, key, value);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(String indexName, String key, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexQuery(this.statement, indexName, key, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits nodeLegacyIndexQuery(String indexName, Object queryOrQueryObject) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexQuery(this.statement, indexName, queryOrQueryObject);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexGet(String indexName, String key, Object value, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexGet(this.statement, indexName, key, value, startNode, endNode);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(String indexName, String key, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexQuery(this.statement, indexName, key, queryOrQueryObject, startNode, endNode);
    }

    @Override
    public LegacyIndexHits relationshipLegacyIndexQuery(String indexName, Object queryOrQueryObject, long startNode, long endNode) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexQuery(this.statement, indexName, queryOrQueryObject, startNode, endNode);
    }

    @Override
    public void nodeLegacyIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeLegacyIndexCreateLazily(this.statement, indexName, customConfig);
    }

    @Override
    public void nodeLegacyIndexCreate(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeLegacyIndexCreate(this.statement, indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreateLazily(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipLegacyIndexCreateLazily(this.statement, indexName, customConfig);
    }

    @Override
    public void relationshipLegacyIndexCreate(String indexName, Map<String, String> customConfig) {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipLegacyIndexCreate(this.statement, indexName, customConfig);
    }

    @Override
    public void nodeAddToLegacyIndex(String indexName, long node, String key, Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeAddToLegacyIndex(this.statement, indexName, node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(String indexName, long node, String key, Object value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeRemoveFromLegacyIndex(this.statement, indexName, node, key, value);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(String indexName, long node, String key) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeRemoveFromLegacyIndex(this.statement, indexName, node, key);
    }

    @Override
    public void nodeRemoveFromLegacyIndex(String indexName, long node) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeRemoveFromLegacyIndex(this.statement, indexName, node);
    }

    @Override
    public void relationshipAddToLegacyIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipAddToLegacyIndex(this.statement, indexName, relationship, key, value);
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(String indexName, long relationship, String key, Object value) throws EntityNotFoundException, LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipRemoveFromLegacyIndex(this.statement, indexName, relationship, key, value);
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(String indexName, long relationship, String key) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipRemoveFromLegacyIndex(this.statement, indexName, relationship, key);
    }

    @Override
    public void relationshipRemoveFromLegacyIndex(String indexName, long relationship) throws LegacyIndexNotFoundKernelException, EntityNotFoundException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipRemoveFromLegacyIndex(this.statement, indexName, relationship);
    }

    @Override
    public void nodeLegacyIndexDrop(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().nodeLegacyIndexDrop(this.statement, indexName);
    }

    @Override
    public void relationshipLegacyIndexDrop(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        this.legacyIndexWrite().relationshipLegacyIndexDrop(this.statement, indexName);
    }

    @Override
    public Map<String, String> nodeLegacyIndexGetConfiguration(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexGetConfiguration(this.statement, indexName);
    }

    @Override
    public Map<String, String> relationshipLegacyIndexGetConfiguration(String indexName) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexGetConfiguration(this.statement, indexName);
    }

    @Override
    public String nodeLegacyIndexSetConfiguration(String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().nodeLegacyIndexSetConfiguration(this.statement, indexName, key, value);
    }

    @Override
    public String relationshipLegacyIndexSetConfiguration(String indexName, String key, String value) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().relationshipLegacyIndexSetConfiguration(this.statement, indexName, key, value);
    }

    @Override
    public String nodeLegacyIndexRemoveConfiguration(String indexName, String key) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().nodeLegacyIndexRemoveConfiguration(this.statement, indexName, key);
    }

    @Override
    public String relationshipLegacyIndexRemoveConfiguration(String indexName, String key) throws LegacyIndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.legacyIndexWrite().relationshipLegacyIndexRemoveConfiguration(this.statement, indexName, key);
    }

    @Override
    public String[] nodeLegacyIndexesGetAll() {
        this.statement.assertOpen();
        return this.legacyIndexRead().nodeLegacyIndexesGetAll(this.statement);
    }

    @Override
    public String[] relationshipLegacyIndexesGetAll() {
        this.statement.assertOpen();
        return this.legacyIndexRead().relationshipLegacyIndexesGetAll(this.statement);
    }

    @Override
    public long countsForNode(int labelId) {
        this.statement.assertOpen();
        return this.counting().countsForNode(this.statement, labelId);
    }

    @Override
    public long countsForNodeWithoutTxState(int labelId) {
        this.statement.assertOpen();
        return this.counting().countsForNodeWithoutTxState(this.statement, labelId);
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        this.statement.assertOpen();
        return this.counting().countsForRelationship(this.statement, startLabelId, typeId, endLabelId);
    }

    @Override
    public long countsForRelationshipWithoutTxState(int startLabelId, int typeId, int endLabelId) {
        this.statement.assertOpen();
        return this.counting().countsForRelationshipWithoutTxState(this.statement, startLabelId, typeId, endLabelId);
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.counting().indexUpdatesAndSize(this.statement, index, target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexDescriptor index, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        this.statement.assertOpen();
        return this.counting().indexSample(this.statement, index, target);
    }

    @Override
    public void setMetaData(Map<String, Object> data) {
        this.statement.assertOpen();
        this.statement.getTransaction().setMetaData(data);
    }

    @Override
    public Stream<ExecutingQuery> executingQueries() {
        this.statement.assertOpen();
        return this.queryRegistrationOperations().executingQueries(this.statement);
    }

    @Override
    public ExecutingQuery startQueryExecution(QuerySource descriptor, String queryText, Map<String, Object> queryParameters) {
        this.statement.assertOpen();
        return this.queryRegistrationOperations().startQueryExecution(this.statement, descriptor, queryText, queryParameters);
    }

    @Override
    public void registerExecutingQuery(ExecutingQuery executingQuery) {
        this.statement.assertOpen();
        this.queryRegistrationOperations().registerExecutingQuery(this.statement, executingQuery);
    }

    @Override
    public void unregisterExecutingQuery(ExecutingQuery executingQuery) {
        this.queryRegistrationOperations().unregisterExecutingQuery(this.statement, executingQuery);
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallRead(QualifiedName name, Object[] input) throws ProcedureException {
        AccessMode accessMode = this.tx.securityContext().mode();
        if (!accessMode.allowsReads()) {
            throw accessMode.onViolation(String.format("Read operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callProcedure(name, input, new RestrictedAccessMode(this.tx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallReadOverride(QualifiedName name, Object[] input) throws ProcedureException {
        return this.callProcedure(name, input, new OverriddenAccessMode(this.tx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWrite(QualifiedName name, Object[] input) throws ProcedureException {
        AccessMode accessMode = this.tx.securityContext().mode();
        if (!accessMode.allowsWrites()) {
            throw accessMode.onViolation(String.format("Write operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callProcedure(name, input, new RestrictedAccessMode(this.tx.securityContext().mode(), AccessMode.Static.WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallWriteOverride(QualifiedName name, Object[] input) throws ProcedureException {
        return this.callProcedure(name, input, new OverriddenAccessMode(this.tx.securityContext().mode(), AccessMode.Static.WRITE));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchema(QualifiedName name, Object[] input) throws ProcedureException {
        AccessMode accessMode = this.tx.securityContext().mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw accessMode.onViolation(String.format("Schema operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callProcedure(name, input, new RestrictedAccessMode(this.tx.securityContext().mode(), AccessMode.Static.FULL));
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallSchemaOverride(QualifiedName name, Object[] input) throws ProcedureException {
        return this.callProcedure(name, input, new OverriddenAccessMode(this.tx.securityContext().mode(), AccessMode.Static.FULL));
    }

    private RawIterator<Object[], ProcedureException> callProcedure(QualifiedName name, Object[] input, AccessMode override) throws ProcedureException {
        RawIterator<Object[], ProcedureException> procedureCall;
        this.statement.assertOpen();
        final SecurityContext procedureSecurityContext = this.tx.securityContext().withMode(override);
        try (KernelTransaction.Revertable ignore = this.tx.overrideWith(procedureSecurityContext);){
            BasicContext ctx = new BasicContext();
            ctx.put(Context.KERNEL_TRANSACTION, this.tx);
            ctx.put(Context.THREAD, Thread.currentThread());
            procedureCall = this.procedures.callProcedure(ctx, name, input);
        }
        return new RawIterator<Object[], ProcedureException>(){

            public boolean hasNext() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = OperationsFacade.this.tx.overrideWith(procedureSecurityContext);){
                    boolean bl = procedureCall.hasNext();
                    return bl;
                }
            }

            public Object[] next() throws ProcedureException {
                try (KernelTransaction.Revertable ignore = OperationsFacade.this.tx.overrideWith(procedureSecurityContext);){
                    Object[] objectArray = (Object[])procedureCall.next();
                    return objectArray;
                }
            }
        };
    }

    @Override
    public Object functionCall(QualifiedName name, Object[] arguments) throws ProcedureException {
        if (!this.tx.securityContext().mode().allowsReads()) {
            throw this.tx.securityContext().mode().onViolation(String.format("Read operations are not allowed for %s.", this.tx.securityContext().description()));
        }
        return this.callFunction(name, arguments, new RestrictedAccessMode(this.tx.securityContext().mode(), AccessMode.Static.READ));
    }

    @Override
    public Object functionCallOverride(QualifiedName name, Object[] arguments) throws ProcedureException {
        return this.callFunction(name, arguments, new OverriddenAccessMode(this.tx.securityContext().mode(), AccessMode.Static.READ));
    }

    private Object callFunction(QualifiedName name, Object[] input, AccessMode mode) throws ProcedureException {
        this.statement.assertOpen();
        try (KernelTransaction.Revertable ignore = this.tx.overrideWith(this.tx.securityContext().withMode(mode));){
            BasicContext ctx = new BasicContext();
            ctx.put(Context.KERNEL_TRANSACTION, this.tx);
            ctx.put(Context.THREAD, Thread.currentThread());
            Object object = this.procedures.callFunction(ctx, name, input);
            return object;
        }
    }
}

