/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.neo4j.helpers.Strings;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;

public class PreexistingIndexEntryConflictException
extends IndexEntryConflictException {
    private final Object propertyValue;
    private final long addedNodeId;
    private final long existingNodeId;

    public PreexistingIndexEntryConflictException(Object propertyValue, long existingNodeId, long addedNodeId) {
        super(String.format("Multiple nodes have property value %s:%n  node(%d)%n  node(%d)", PreexistingIndexEntryConflictException.quote(propertyValue), existingNodeId, addedNodeId));
        this.addedNodeId = addedNodeId;
        this.propertyValue = propertyValue;
        this.existingNodeId = existingNodeId;
    }

    @Override
    public Object getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public String evidenceMessage(String labelName, String propertyKey) {
        return String.format("Multiple nodes with label `%s` have property `%s` = %s:%n  node(%d)%n  node(%d)", labelName, propertyKey, PreexistingIndexEntryConflictException.quote(this.propertyValue), this.existingNodeId, this.addedNodeId);
    }

    public long getAddedNodeId() {
        return this.addedNodeId;
    }

    public long getExistingNodeId() {
        return this.existingNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreexistingIndexEntryConflictException that = (PreexistingIndexEntryConflictException)o;
        return this.addedNodeId == that.addedNodeId && this.existingNodeId == that.existingNodeId && !(this.propertyValue == null ? that.propertyValue != null : !this.propertyValue.equals(that.propertyValue));
    }

    public int hashCode() {
        int result = this.propertyValue != null ? this.propertyValue.hashCode() : 0;
        result = 31 * result + (int)(this.addedNodeId ^ this.addedNodeId >>> 32);
        result = 31 * result + (int)(this.existingNodeId ^ this.existingNodeId >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "PreexistingIndexEntryConflictException{propertyValue=" + Strings.prettyPrint(this.propertyValue) + ", addedNodeId=" + this.addedNodeId + ", existingNodeId=" + this.existingNodeId + '}';
    }
}

