/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.storageengine.api.EntityType;

public class EntitySchemaRuleNotFoundException
extends SchemaRuleNotFoundException {
    private static final String NODE_RULE_NOT_FOUND_MESSAGE_TEMPLATE = "%s for label '%s' and property '%s' not found.";
    private static final String RELATIONSHIP_RULE_NOT_FOUND_MESSAGE_TEMPLATE = "%s for relationship type '%s' and property '%s' not found.";
    private final EntityType entityType;

    public EntitySchemaRuleNotFoundException(EntityType entityType, int labelId, int propertyKeyId) {
        this(entityType, labelId, propertyKeyId, false);
    }

    public EntitySchemaRuleNotFoundException(EntityType entityType, int entityId, int propertyKeyId, boolean unique) {
        super(EntitySchemaRuleNotFoundException.getMessageTemplate(entityType), entityId, propertyKeyId, unique ? "Uniqueness constraint" : "Constraint");
        this.entityType = entityType;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        String entityName = EntityType.NODE == this.entityType ? tokenNameLookup.labelGetName(this.ruleEntityId) : tokenNameLookup.relationshipTypeGetName(this.ruleEntityId);
        return String.format(this.messageTemplate, this.messagePrefix, entityName, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    private static String getMessageTemplate(EntityType entityType) {
        switch (entityType) {
            case NODE: {
                return NODE_RULE_NOT_FOUND_MESSAGE_TEMPLATE;
            }
            case RELATIONSHIP: {
                return RELATIONSHIP_RULE_NOT_FOUND_MESSAGE_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Schema rules for specified entityType not supported.");
    }
}

