/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;

class BooleanArrayProperty
extends DefinedProperty {
    private final boolean[] value;

    BooleanArrayProperty(int propertyKeyId, boolean[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public boolean[] value() {
        return (boolean[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object other) {
        return BooleanArrayProperty.valueEquals(this.value, other);
    }

    static boolean valueEquals(boolean[] value, Object other) {
        Boolean[] that;
        int length;
        if (other instanceof boolean[]) {
            return Arrays.equals(value, (boolean[])other);
        }
        if (other instanceof Boolean[] && (length = value.length) == (that = (Boolean[])other).length) {
            for (int i = 0; i < length; ++i) {
                Boolean bool = that[i];
                if (bool != null && bool == value[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    int valueHash() {
        return BooleanArrayProperty.hash(this.value);
    }

    static int hash(boolean[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return that instanceof BooleanArrayProperty && Arrays.equals(this.value, ((BooleanArrayProperty)that).value);
    }
}

