/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.function.Predicate;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.unsafe.impl.batchimport.AssignRelationshipIdBatchStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.InputIteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipPreparationStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipRecordPreparationStep;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class RelationshipStage
extends Stage {
    private AssignRelationshipIdBatchStep idAssigner;

    public RelationshipStage(String topic, Configuration config, IoMonitor writeMonitor, Predicate<InputRelationship> typeFilter, InputIterator<InputRelationship> relationships, IdMapper idMapper, BatchingNeoStores neoStore, NodeRelationshipCache cache, EntityStoreUpdaterStep.Monitor storeUpdateMonitor, long firstRelationshipId) {
        super("Relationships" + topic, config, 1);
        this.add(new InputIteratorBatcherStep<InputRelationship>(this.control(), config, relationships, InputRelationship.class, typeFilter));
        RelationshipStore relationshipStore = neoStore.getRelationshipStore();
        PropertyStore propertyStore = neoStore.getPropertyStore();
        this.idAssigner = new AssignRelationshipIdBatchStep(this.control(), config, firstRelationshipId);
        this.add(this.idAssigner);
        this.add(new RelationshipPreparationStep(this.control(), config, idMapper));
        this.add(new RelationshipRecordPreparationStep(this.control(), config, neoStore.getRelationshipTypeRepository()));
        this.add(new PropertyEncoderStep(this.control(), config, neoStore.getPropertyKeyRepository(), propertyStore));
        this.add(new RelationshipEncoderStep(this.control(), config, cache));
        this.add(new EntityStoreUpdaterStep(this.control(), config, relationshipStore, propertyStore, writeMonitor, storeUpdateMonitor));
    }

    public long getNextRelationshipId() {
        return this.idAssigner.getNextRelationshipId();
    }
}

