/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class UniquePropertyConstraintRule
extends NodePropertyConstraintRule {
    private final int[] propertyKeyIds;
    private final long ownedIndexRule;

    public static UniquePropertyConstraintRule uniquenessConstraintRule(long id, int labelId, int propertyKeyId, long ownedIndexRule) {
        return new UniquePropertyConstraintRule(id, labelId, new int[]{propertyKeyId}, ownedIndexRule);
    }

    public static UniquePropertyConstraintRule readUniquenessConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new UniquePropertyConstraintRule(id, labelId, UniquePropertyConstraintRule.readPropertyKeys(buffer), UniquePropertyConstraintRule.readOwnedIndexRule(buffer));
    }

    private UniquePropertyConstraintRule(long id, int labelId, int[] propertyKeyIds, long ownedIndexRule) {
        super(id, labelId, SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
        this.ownedIndexRule = ownedIndexRule;
        assert (propertyKeyIds.length == 1);
        this.propertyKeyIds = propertyKeyIds;
    }

    @Override
    public String toString() {
        return "UniquePropertyConstraintRule[id=" + this.id + ", label=" + this.label + ", kind=" + (Object)((Object)this.kind) + ", propertyKeys=" + Arrays.toString(this.propertyKeyIds) + ", ownedIndex=" + this.ownedIndexRule + "]";
    }

    @Override
    public int length() {
        return 6 + 8 * this.propertyKeyIds.length + 8;
    }

    @Override
    public void serialize(ByteBuffer target) {
        target.putInt(this.label);
        target.put(this.kind.id());
        target.put((byte)this.propertyKeyIds.length);
        for (int propertyKeyId : this.propertyKeyIds) {
            target.putLong(propertyKeyId);
        }
        target.putLong(this.ownedIndexRule);
    }

    private static int[] readPropertyKeys(ByteBuffer buffer) {
        int[] keys = new int[buffer.get()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = IoPrimitiveUtils.safeCastLongToInt(buffer.getLong());
        }
        return keys;
    }

    private static long readOwnedIndexRule(ByteBuffer buffer) {
        return buffer.getLong();
    }

    @Override
    public boolean containsPropertyKeyId(int propertyKeyId) {
        for (int keyId : this.propertyKeyIds) {
            if (keyId != propertyKeyId) continue;
            return true;
        }
        return false;
    }

    public int getPropertyKey() {
        return this.propertyKeyIds[0];
    }

    public long getOwnedIndex() {
        return this.ownedIndexRule;
    }

    @Override
    public UniquenessConstraint toConstraint() {
        return new UniquenessConstraint(this.getLabel(), this.getPropertyKey());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.propertyKeyIds, ((UniquePropertyConstraintRule)o).propertyKeyIds);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Arrays.hashCode(this.propertyKeyIds);
    }
}

