/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;

public class CreateConstraintFailureException
extends SchemaKernelException {
    private final PropertyConstraint constraint;

    public CreateConstraintFailureException(PropertyConstraint constraint, Throwable cause) {
        super((Status)Status.Schema.ConstraintCreationFailed, cause, "Unable to create constraint %s: %s", constraint, cause.getMessage());
        this.constraint = constraint;
    }

    public PropertyConstraint constraint() {
        return this.constraint;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        String message = "Unable to create " + this.constraint.userDescription(tokenNameLookup);
        if (this.getCause() instanceof KernelException) {
            KernelException cause = (KernelException)this.getCause();
            return String.format("%s:%n%s", message, cause.getUserMessage(tokenNameLookup));
        }
        return message;
    }
}

