/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.monitoring;

import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.logging.Log;

public class VisibleMigrationProgressMonitor
implements MigrationProgressMonitor {
    static final String MESSAGE_STARTED = "Starting upgrade of database";
    static final String MESSAGE_COMPLETED = "Successfully finished upgrade of database";
    private final Log log;

    public VisibleMigrationProgressMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void started() {
        this.log.info(MESSAGE_STARTED);
    }

    @Override
    public MigrationProgressMonitor.Section startSection(String name) {
        this.log.info("Migrating " + name + ":");
        return new ProgressSection();
    }

    @Override
    public void completed() {
        this.log.info(MESSAGE_COMPLETED);
    }

    private class ProgressSection
    implements MigrationProgressMonitor.Section {
        private static final int STRIDE = 10;
        private static final int HUNDRED = 100;
        private long current;
        private int currentPercent;
        private long max;

        private ProgressSection() {
        }

        @Override
        public void progress(long add) {
            this.current += add;
            int percent = this.max == 0L ? 100 : Math.min(100, (int)(this.current * 100L / this.max));
            this.ensurePercentReported(percent);
        }

        private void ensurePercentReported(int percent) {
            while (this.currentPercent < percent) {
                this.reportPercent(++this.currentPercent);
            }
        }

        private void reportPercent(int percent) {
            if (percent % 10 == 0) {
                VisibleMigrationProgressMonitor.this.log.info(String.format("  %d%% completed", percent));
            }
        }

        @Override
        public void start(long max) {
            this.max = max;
        }

        @Override
        public void completed() {
            this.ensurePercentReported(100);
        }
    }
}

