/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.helpers.collection.MultiSet;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class DefaultNonUniqueIndexSampler
implements NonUniqueIndexSampler {
    private final int sampleSizeLimit;
    private final MultiSet<String> values;
    private int sampledSteps = 0;
    private long accumulatedUniqueValues = 0L;
    private long accumulatedSampledSize = 0L;
    private long sampleSize = 0L;

    public DefaultNonUniqueIndexSampler(int sampleSizeLimit) {
        this.values = new MultiSet(this.calculateInitialSetSize(sampleSizeLimit));
        this.sampleSizeLimit = sampleSizeLimit;
    }

    @Override
    public void include(String value) {
        this.include(value, 1L);
    }

    @Override
    public void include(String value, long increment) {
        assert (increment > 0L);
        if (this.sampleSize >= (long)this.sampleSizeLimit) {
            this.nextStep();
        }
        if (this.values.increment((Object)value, increment) == increment) {
            this.sampleSize += (long)value.length();
        }
    }

    @Override
    public void exclude(String value) {
        this.exclude(value, 1L);
    }

    @Override
    public void exclude(String value, long decrement) {
        assert (decrement > 0L);
        if (this.values.increment((Object)value, -decrement) == 0L) {
            this.sampleSize -= (long)value.length();
        }
    }

    @Override
    public IndexSample result() {
        return this.result(-1);
    }

    @Override
    public IndexSample result(int numDocs) {
        if (!this.values.isEmpty()) {
            this.nextStep();
        }
        long uniqueValues = this.sampledSteps != 0 ? this.accumulatedUniqueValues / (long)this.sampledSteps : 0L;
        long sampledSize = this.sampledSteps != 0 ? this.accumulatedSampledSize / (long)this.sampledSteps : 0L;
        return new IndexSample(numDocs < 0 ? this.accumulatedSampledSize : (long)numDocs, uniqueValues, sampledSize);
    }

    private void nextStep() {
        this.accumulatedUniqueValues += (long)this.values.uniqueSize();
        this.accumulatedSampledSize += (long)this.values.size();
        this.sampleSize = 0L;
        ++this.sampledSteps;
        this.values.clear();
    }

    private int calculateInitialSetSize(int sampleSizeLimit) {
        int basedOnSampleSize = Math.max(10, (int)(Math.log(sampleSizeLimit) / Math.log(2.0)) / 2);
        return 1 << Math.min(16, basedOnSampleSize);
    }
}

