/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.List;
import java.util.Set;

public interface NotificationDetail {
    public String name();

    public String value();

    public static final class Factory {
        public static NotificationDetail deprecatedName(String oldName, String newName) {
            return Factory.createDeprecationNotificationDetail(oldName, newName);
        }

        public static NotificationDetail index(String labelName, String propertyKeyName) {
            return Factory.createNotificationDetail("hinted index", String.format("index on :%s(%s)", labelName, propertyKeyName), true);
        }

        public static NotificationDetail label(String labelName) {
            return Factory.createNotificationDetail("the missing label name is", labelName, true);
        }

        public static NotificationDetail relationshipType(String relType) {
            return Factory.createNotificationDetail("the missing relationship type is", relType, true);
        }

        public static NotificationDetail propertyName(String name) {
            return Factory.createNotificationDetail("the missing property name is", name, true);
        }

        public static NotificationDetail joinKey(List<String> identifiers) {
            boolean singular = identifiers.size() == 1;
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String identifier : identifiers) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(identifier);
            }
            return Factory.createNotificationDetail(singular ? "hinted join key identifier" : "hinted join key identifiers", builder.toString(), singular);
        }

        public static NotificationDetail cartesianProduct(Set<String> identifiers) {
            return Factory.createNotificationDetail(identifiers, "identifier", "identifiers");
        }

        public static NotificationDetail indexSeekOrScan(Set<String> labels) {
            return Factory.createNotificationDetail(labels, "indexed label", "indexed labels");
        }

        private static NotificationDetail createNotificationDetail(Set<String> elements, String singularTerm, String pluralTerm) {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            String separator = "";
            for (String element : elements) {
                builder.append(separator);
                builder.append(element);
                separator = ", ";
            }
            builder.append(")");
            boolean singular = elements.size() == 1;
            return Factory.createNotificationDetail(singular ? singularTerm : pluralTerm, builder.toString(), singular);
        }

        private static NotificationDetail createNotificationDetail(final String name, final String value, final boolean singular) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String value() {
                    return value;
                }

                public String toString() {
                    return String.format("%s %s %s", name, singular ? "is:" : "are:", value);
                }
            };
        }

        private static NotificationDetail createDeprecationNotificationDetail(final String oldName, final String newName) {
            return new NotificationDetail(){

                @Override
                public String name() {
                    return oldName;
                }

                @Override
                public String value() {
                    return newName;
                }

                public String toString() {
                    if (newName == null || newName.trim().isEmpty()) {
                        return String.format("'%s' is no longer supported", oldName);
                    }
                    return String.format("'%s' has been replaced by '%s'", oldName, newName);
                }
            };
        }
    }
}

