/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.util.Collections;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;

public interface AuthToken {
    public static final String SCHEME_KEY = "scheme";
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIALS = "credentials";
    public static final String REALM_KEY = "realm";
    public static final String PARAMETERS = "parameters";
    public static final String NEW_CREDENTIALS = "new_credentials";
    public static final String BASIC_SCHEME = "basic";
    public static final String NATIVE_REALM = "native";

    public static String safeCast(String key, Map<String, Object> authToken) throws InvalidAuthTokenException {
        Object value = authToken.get(key);
        if (value == null || !(value instanceof String)) {
            throw new InvalidAuthTokenException("The value associated with the key `" + key + "` must be a String but was: " + (value == null ? "null" : value.getClass().getSimpleName()));
        }
        return (String)value;
    }

    public static Map<String, Object> safeCastMap(String key, Map<String, Object> authToken) throws InvalidAuthTokenException {
        Object value = authToken.get(key);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new InvalidAuthTokenException("The value associated with the key `" + key + "` must be a Map but was: " + value.getClass().getSimpleName());
    }

    public static Map<String, Object> newBasicAuthToken(String username, String password) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, BASIC_SCHEME, PRINCIPAL, username, CREDENTIALS, password});
    }

    public static Map<String, Object> newBasicAuthToken(String username, String password, String realm) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, BASIC_SCHEME, PRINCIPAL, username, CREDENTIALS, password, REALM_KEY, realm});
    }

    public static Map<String, Object> newCustomAuthToken(String principle, String credentials, String realm, String scheme) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, scheme, PRINCIPAL, principle, CREDENTIALS, credentials, REALM_KEY, realm});
    }

    public static Map<String, Object> newCustomAuthToken(String principle, String credentials, String realm, String scheme, Map<String, Object> parameters) {
        return MapUtil.map((Object[])new Object[]{SCHEME_KEY, scheme, PRINCIPAL, principle, CREDENTIALS, credentials, REALM_KEY, realm, PARAMETERS, parameters});
    }
}

