/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplierFacade;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.storageengine.api.CommandsToApply;

public class BatchTransactionApplierFacade
implements BatchTransactionApplier {
    private final BatchTransactionApplier[] appliers;

    public BatchTransactionApplierFacade(BatchTransactionApplier ... appliers) {
        this.appliers = appliers;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) throws IOException {
        TransactionApplier[] txAppliers = new TransactionApplier[this.appliers.length];
        for (int i = 0; i < this.appliers.length; ++i) {
            txAppliers[i] = this.appliers[i].startTx(transaction);
        }
        return new TransactionApplierFacade(txAppliers);
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, LockGroup lockGroup) throws IOException {
        TransactionApplier[] txAppliers = new TransactionApplier[this.appliers.length];
        for (int i = 0; i < this.appliers.length; ++i) {
            txAppliers[i] = this.appliers[i].startTx(transaction, lockGroup);
        }
        return new TransactionApplierFacade(txAppliers);
    }

    @Override
    public void close() throws Exception {
        int i = this.appliers.length;
        while (i-- > 0) {
            this.appliers[i].close();
        }
    }
}

