/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CountsComputer
implements DataInitializer<CountsAccessor.Updater> {
    private final NodeStore nodes;
    private final RelationshipStore relationships;
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final long lastCommittedTransactionId;

    public static void recomputeCounts(NeoStores stores) {
        MetaDataStore metaDataStore = stores.getMetaDataStore();
        CountsTracker counts = stores.getCounts();
        try (CountsAccessor.Updater updater = counts.reset(metaDataStore.getLastCommittedTransactionId());){
            new CountsComputer(stores).initialize(updater);
        }
    }

    public CountsComputer(NeoStores stores) {
        this(stores.getMetaDataStore().getLastCommittedTransactionId(), stores.getNodeStore(), stores.getRelationshipStore(), (int)stores.getLabelTokenStore().getHighId(), (int)stores.getRelationshipTypeTokenStore().getHighId());
    }

    public CountsComputer(long lastCommittedTransactionId, NodeStore nodes, RelationshipStore relationships, int highLabelId, int highRelationshipTypeId) {
        this.lastCommittedTransactionId = lastCommittedTransactionId;
        this.nodes = nodes;
        this.relationships = relationships;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
    }

    @Override
    public void initialize(CountsAccessor.Updater countsUpdater) {
        try (NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactory.AUTO, this.highLabelId);){
            ExecutionSupervisors.superviseDynamicExecution(new NodeCountsStage(Configuration.DEFAULT, cache, this.nodes, this.highLabelId, countsUpdater, new StatsProvider[0]));
            ExecutionSupervisors.superviseDynamicExecution(new RelationshipCountsStage(Configuration.DEFAULT, cache, this.relationships, this.highLabelId, this.highRelationshipTypeId, countsUpdater, NumberArrayFactory.AUTO));
        }
    }

    @Override
    public long initialVersion() {
        return this.lastCommittedTransactionId;
    }
}

