/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txtracking;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionIdTracker {
    private static final int POLL_INTERVAL = 25;
    private static final TimeUnit POLL_UNIT = TimeUnit.MILLISECONDS;
    private final TransactionIdStore transactionIdStore;

    public TransactionIdTracker(TransactionIdStore transactionIdStore) {
        this.transactionIdStore = transactionIdStore;
    }

    public void awaitUpToDate(long oldestAcceptableTxId, Duration timeout) throws TransactionFailureException {
        if (oldestAcceptableTxId <= 1L) {
            return;
        }
        if (!Predicates.tryAwait(() -> oldestAcceptableTxId <= this.transactionIdStore.getLastClosedTransactionId(), (long)timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (long)25L, (TimeUnit)POLL_UNIT)) {
            throw new TransactionFailureException((Status)Status.Transaction.InstanceStateChanged, "Database not up to the requested version: %d. Latest database version is %d", oldestAcceptableTxId, this.transactionIdStore.getLastClosedTransactionId());
        }
    }

    public long newestEncounteredTxId() {
        return this.transactionIdStore.getLastClosedTransactionId();
    }
}

