/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.io.IOException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.impl.api.security.AccessModeSnapshot;

public interface AuthSubject
extends AccessMode {
    public static final AuthSubject ANONYMOUS = new StaticAccessModeAdapter(AccessMode.Static.NONE){

        @Override
        public void logout() {
        }

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.FAILURE;
        }

        @Override
        public void setPassword(String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
            throw new AuthorizationViolationException("Anonymous cannot change password");
        }

        @Override
        public void setPasswordChangeNoLongerRequired() {
        }

        @Override
        public boolean hasUsername(String username) {
            return false;
        }

        @Override
        public boolean allowsProcedureWith(String[] roleNames) {
            return false;
        }

        @Override
        public String name() {
            return "<anonymous>";
        }
    };
    public static final AuthSubject AUTH_DISABLED = new StaticAccessModeAdapter(AccessMode.Static.FULL){

        @Override
        public String name() {
            return "<auth disabled>";
        }

        @Override
        public void logout() {
        }

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.SUCCESS;
        }

        @Override
        public void setPassword(String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        }

        @Override
        public void setPasswordChangeNoLongerRequired() {
        }

        @Override
        public boolean hasUsername(String username) {
            return false;
        }

        @Override
        public boolean allowsProcedureWith(String[] roleNames) {
            return true;
        }
    };

    public void logout();

    public AuthenticationResult getAuthenticationResult();

    public void setPassword(String var1, boolean var2) throws IOException, InvalidArgumentsException;

    public void setPasswordChangeNoLongerRequired();

    public boolean hasUsername(String var1);

    default public void ensureUserExistsWithName(String username) throws InvalidArgumentsException {
        throw new InvalidArgumentsException("User '" + username + "' does not exit.");
    }

    @Override
    default public AccessMode getSnapshot() {
        return AccessModeSnapshot.create(this);
    }

    public static abstract class StaticAccessModeAdapter
    implements AuthSubject {
        private final AccessMode accessMode;

        public StaticAccessModeAdapter(AccessMode.Static accessMode) {
            this.accessMode = accessMode;
        }

        @Override
        public boolean allowsReads() {
            return this.accessMode.allowsReads();
        }

        @Override
        public boolean allowsWrites() {
            return this.accessMode.allowsWrites();
        }

        @Override
        public boolean allowsSchemaWrites() {
            return this.accessMode.allowsSchemaWrites();
        }

        @Override
        public boolean isOverridden() {
            return this.accessMode.isOverridden();
        }

        @Override
        public AuthorizationViolationException onViolation(String msg) {
            return this.accessMode.onViolation(msg);
        }

        @Override
        public String name() {
            return this.accessMode.name();
        }
    }
}

