/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import java.util.Optional;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.Neo4jValue;

public class FieldSignature {
    private final String name;
    private final Neo4jTypes.AnyType type;
    private final Optional<Neo4jValue> defaultValue;

    public FieldSignature(String name, Neo4jTypes.AnyType type) {
        this(name, type, Optional.empty());
    }

    public FieldSignature(String name, Neo4jTypes.AnyType type, Optional<Neo4jValue> defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String name() {
        return this.name;
    }

    public Neo4jTypes.AnyType neo4jType() {
        return this.type;
    }

    public Optional<Neo4jValue> defaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        String nameValue = this.defaultValue.isPresent() ? this.name + " = " + this.defaultValue.get().value() : this.name;
        return String.format("%s :: %s", nameValue, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldSignature that = (FieldSignature)o;
        return this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

