/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.constraints.NodePropertyConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;

public class UniquenessConstraint
extends NodePropertyConstraint {
    public UniquenessConstraint(int labelId, int propertyKeyId) {
        super(labelId, propertyKeyId);
    }

    @Override
    public void added(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitAddedUniquePropertyConstraint(this);
    }

    @Override
    public void removed(PropertyConstraint.ChangeVisitor visitor) {
        visitor.visitRemovedUniquePropertyConstraint(this);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        String labelName = this.labelName(tokenNameLookup);
        String boundIdentifier = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s.%s IS UNIQUE", boundIdentifier, labelName, boundIdentifier, tokenNameLookup.propertyKeyGetName(this.propertyKeyId));
    }

    @Override
    public String toString() {
        return String.format("CONSTRAINT ON ( n:label[%s] ) ASSERT n.property[%s] IS UNIQUE", this.labelId, this.propertyKeyId);
    }
}

