/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.math.BigDecimal;

public abstract class MathUtil {
    private static final long NON_DOUBLE_LONG = -9007199254740992L;

    public static boolean numbersEqual(double fpn, long in) {
        if (in < 0L) {
            if (fpn < 0.0) {
                if ((0xFFE0000000000000L & in) == -9007199254740992L) {
                    return fpn == (double)in;
                }
                if (fpn < -9.223372036854776E18) {
                    return false;
                }
                if (fpn == Math.floor(fpn) && !Double.isInfinite(fpn)) {
                    return in == (long)fpn;
                }
            }
        } else if (!(fpn < 0.0)) {
            if ((0xFFE0000000000000L & in) == 0L) {
                return fpn == (double)in;
            }
            if (fpn > 9.223372036854776E18) {
                return false;
            }
            if (fpn == Math.floor(fpn) && !Double.isInfinite(fpn)) {
                return in == (long)fpn;
            }
        }
        return false;
    }

    public static int compareDoubleAgainstLong(double lhs, long rhs) {
        if ((0xFFE0000000000000L & rhs) != -9007199254740992L) {
            if (Double.isNaN(lhs)) {
                return 1;
            }
            if (Double.isInfinite(lhs)) {
                return lhs < 0.0 ? -1 : 1;
            }
            return BigDecimal.valueOf(lhs).compareTo(BigDecimal.valueOf(rhs));
        }
        return Double.compare(lhs, rhs);
    }

    public static int compareLongAgainstDouble(long lhs, double rhs) {
        return -MathUtil.compareDoubleAgainstLong(rhs, lhs);
    }

    public static int decrementExactNotPastZero(int value) {
        if (value == 0) {
            throw new ArithmeticException("integer underflow past zero");
        }
        return value - 1;
    }
}

