/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;

public class ReadOnlyTransactionStore
extends LifecycleAdapter
implements LogicalTransactionStore {
    private final LifeSupport life = new LifeSupport();
    private final LogicalTransactionStore physicalStore;

    public ReadOnlyTransactionStore(PageCache pageCache, FileSystemAbstraction fs, File fromPath, Monitors monitors) throws IOException {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(fromPath, fs);
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(100);
        LogHeaderCache logHeaderCache = new LogHeaderCache(10);
        ReadOnlyTransactionIdStore transactionIdStore = new ReadOnlyTransactionIdStore(pageCache, fromPath);
        PhysicalLogFile logFile = (PhysicalLogFile)this.life.add((Lifecycle)new PhysicalLogFile(fs, logFiles, 0L, transactionIdStore::getLastCommittedTransactionId, new ReadOnlyLogVersionRepository(pageCache, fromPath), monitors.newMonitor(PhysicalLogFile.Monitor.class, new String[0]), logHeaderCache));
        VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader = new VersionAwareLogEntryReader<ReadableClosablePositionAwareChannel>();
        this.physicalStore = new PhysicalLogicalTransactionStore(logFile, transactionMetadataCache, logEntryReader);
    }

    @Override
    public TransactionCursor getTransactions(long transactionIdToStartFrom) throws NoSuchTransactionException, IOException {
        return this.physicalStore.getTransactions(transactionIdToStartFrom);
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws NoSuchTransactionException, IOException {
        return this.physicalStore.getTransactions(position);
    }

    @Override
    public TransactionMetadataCache.TransactionMetadata getMetadataFor(long transactionId) throws NoSuchTransactionException, IOException {
        return this.physicalStore.getMetadataFor(transactionId);
    }

    public void init() throws Throwable {
        this.life.init();
    }

    public void start() throws Throwable {
        this.life.start();
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }
}

