/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;

public class PhysicalLogVersionedStoreChannel
implements LogVersionedStoreChannel {
    private final StoreChannel delegateChannel;
    private final long version;
    private final byte formatVersion;
    private long position;

    public PhysicalLogVersionedStoreChannel(StoreChannel delegateChannel, long version, byte formatVersion) throws IOException {
        this.delegateChannel = delegateChannel;
        this.version = version;
        this.formatVersion = formatVersion;
        this.position = delegateChannel.position();
    }

    public FileLock tryLock() throws IOException {
        return this.delegateChannel.tryLock();
    }

    public int write(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException("Not needed");
    }

    public void writeAll(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException("Not needed");
    }

    public void writeAll(ByteBuffer src) throws IOException {
        this.advance(src.remaining());
        this.delegateChannel.writeAll(src);
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        throw new UnsupportedOperationException("Not needed");
    }

    public void force(boolean metaData) throws IOException {
        this.delegateChannel.force(metaData);
    }

    public StoreChannel position(long newPosition) throws IOException {
        this.position = newPosition;
        return this.delegateChannel.position(newPosition);
    }

    public StoreChannel truncate(long size) throws IOException {
        return this.delegateChannel.truncate(size);
    }

    public int read(ByteBuffer dst) throws IOException {
        return (int)this.advance(this.delegateChannel.read(dst));
    }

    private long advance(long bytes) {
        if (bytes != -1L) {
            this.position += bytes;
        }
        return bytes;
    }

    public int write(ByteBuffer src) throws IOException {
        return (int)this.advance(this.delegateChannel.write(src));
    }

    public long position() throws IOException {
        return this.position;
    }

    public long size() throws IOException {
        return this.delegateChannel.size();
    }

    public boolean isOpen() {
        return this.delegateChannel.isOpen();
    }

    public void close() throws IOException {
        this.delegateChannel.close();
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.advance(this.delegateChannel.write(srcs, offset, length));
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.advance(this.delegateChannel.write(srcs));
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.advance(this.delegateChannel.read(dsts, offset, length));
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.advance(this.delegateChannel.read(dsts));
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public byte getLogFormatVersion() {
        return this.formatVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhysicalLogVersionedStoreChannel that = (PhysicalLogVersionedStoreChannel)o;
        if (this.version != that.version) {
            return false;
        }
        return this.delegateChannel.equals(that.delegateChannel);
    }

    public int hashCode() {
        int result = this.delegateChannel.hashCode();
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public void flush() throws IOException {
        this.force(false);
    }
}

