/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.function.Predicate;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class StoreAccess {
    private RecordStore<DynamicRecord> schemaStore;
    private RecordStore<NodeRecord> nodeStore;
    private RecordStore<RelationshipRecord> relStore;
    private RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore;
    private RecordStore<LabelTokenRecord> labelTokenStore;
    private RecordStore<DynamicRecord> nodeDynamicLabelStore;
    private RecordStore<PropertyRecord> propStore;
    private RecordStore<DynamicRecord> stringStore;
    private RecordStore<DynamicRecord> arrayStore;
    private RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore;
    private RecordStore<DynamicRecord> relationshipTypeNameStore;
    private RecordStore<DynamicRecord> labelNameStore;
    private RecordStore<DynamicRecord> propertyKeyNameStore;
    private RecordStore<RelationshipGroupRecord> relGroupStore;
    private final CountsAccessor counts;
    private boolean closeable;
    private final NeoStores neoStores;

    public StoreAccess(NeoStores store) {
        this.neoStores = store;
        this.counts = store.getCounts();
    }

    public StoreAccess(PageCache pageCache, File storeDir) {
        this((FileSystemAbstraction)new DefaultFileSystemAbstraction(), pageCache, storeDir);
    }

    public StoreAccess(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir) {
        this(fileSystem, pageCache, storeDir, Config.defaults());
    }

    public StoreAccess(FileSystemAbstraction fileSystem, PageCache pageCache, File storeDir, Config config) {
        this(new StoreFactory(storeDir, config, new DefaultIdGeneratorFactory(fileSystem), pageCache, fileSystem, (LogProvider)NullLogProvider.getInstance()).openAllNeoStores());
        this.closeable = true;
    }

    public StoreAccess initialize() {
        this.schemaStore = this.wrapStore(this.neoStores.getSchemaStore());
        this.nodeStore = this.wrapStore(this.neoStores.getNodeStore());
        this.relStore = this.wrapStore(this.neoStores.getRelationshipStore());
        this.propStore = this.wrapStore(this.neoStores.getPropertyStore());
        this.stringStore = this.wrapStore(this.neoStores.getPropertyStore().getStringStore());
        this.arrayStore = this.wrapStore(this.neoStores.getPropertyStore().getArrayStore());
        this.relationshipTypeTokenStore = this.wrapStore(this.neoStores.getRelationshipTypeTokenStore());
        this.labelTokenStore = this.wrapStore(this.neoStores.getLabelTokenStore());
        this.nodeDynamicLabelStore = this.wrapStore(StoreAccess.wrapNodeDynamicLabelStore(this.neoStores.getNodeStore().getDynamicLabelStore()));
        this.propertyKeyTokenStore = this.wrapStore(this.neoStores.getPropertyStore().getPropertyKeyTokenStore());
        this.relationshipTypeNameStore = this.wrapStore(this.neoStores.getRelationshipTypeTokenStore().getNameStore());
        this.labelNameStore = this.wrapStore(this.neoStores.getLabelTokenStore().getNameStore());
        this.propertyKeyNameStore = this.wrapStore(this.neoStores.getPropertyStore().getPropertyKeyTokenStore().getNameStore());
        this.relGroupStore = this.wrapStore(this.neoStores.getRelationshipGroupStore());
        return this;
    }

    public NeoStores getRawNeoStores() {
        return this.neoStores;
    }

    public RecordStore<DynamicRecord> getSchemaStore() {
        return this.schemaStore;
    }

    public RecordStore<NodeRecord> getNodeStore() {
        return this.nodeStore;
    }

    public RecordStore<RelationshipRecord> getRelationshipStore() {
        return this.relStore;
    }

    public RecordStore<RelationshipGroupRecord> getRelationshipGroupStore() {
        return this.relGroupStore;
    }

    public RecordStore<PropertyRecord> getPropertyStore() {
        return this.propStore;
    }

    public RecordStore<DynamicRecord> getStringStore() {
        return this.stringStore;
    }

    public RecordStore<DynamicRecord> getArrayStore() {
        return this.arrayStore;
    }

    public RecordStore<RelationshipTypeTokenRecord> getRelationshipTypeTokenStore() {
        return this.relationshipTypeTokenStore;
    }

    public RecordStore<LabelTokenRecord> getLabelTokenStore() {
        return this.labelTokenStore;
    }

    public RecordStore<DynamicRecord> getNodeDynamicLabelStore() {
        return this.nodeDynamicLabelStore;
    }

    public RecordStore<PropertyKeyTokenRecord> getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    public RecordStore<DynamicRecord> getRelationshipTypeNameStore() {
        return this.relationshipTypeNameStore;
    }

    public RecordStore<DynamicRecord> getLabelNameStore() {
        return this.labelNameStore;
    }

    public RecordStore<DynamicRecord> getPropertyKeyNameStore() {
        return this.propertyKeyNameStore;
    }

    public CountsAccessor getCounts() {
        return this.counts;
    }

    protected RecordStore<?>[] allStores() {
        if (this.propStore == null) {
            return new RecordStore[]{this.nodeStore, this.relStore, this.relationshipTypeTokenStore, this.relationshipTypeNameStore, this.labelTokenStore, this.labelNameStore, this.nodeDynamicLabelStore};
        }
        return new RecordStore[]{this.schemaStore, this.nodeStore, this.relStore, this.propStore, this.stringStore, this.arrayStore, this.relationshipTypeTokenStore, this.propertyKeyTokenStore, this.labelTokenStore, this.relationshipTypeNameStore, this.propertyKeyNameStore, this.labelNameStore, this.nodeDynamicLabelStore};
    }

    private static RecordStore<DynamicRecord> wrapNodeDynamicLabelStore(RecordStore<DynamicRecord> store) {
        return new RecordStore.Delegator<DynamicRecord>(store){

            @Override
            public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, DynamicRecord record) throws FAILURE {
                processor.processLabelArrayWithOwner(this, record);
            }
        };
    }

    protected <R extends AbstractBaseRecord> RecordStore<R> wrapStore(RecordStore<R> store) {
        return store;
    }

    protected <FAILURE extends Exception> void apply(RecordStore.Processor<FAILURE> processor, RecordStore<?> store) throws FAILURE {
        processor.applyFiltered(store, new Predicate[0]);
    }

    public synchronized void close() {
        if (this.closeable) {
            this.closeable = false;
            this.neoStores.close();
        }
    }
}

