/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.AccessCapability;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.ProceduresProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public abstract class EditionModule {
    public IdGeneratorFactory idGeneratorFactory;
    public IdTypeConfigurationProvider idTypeConfigurationProvider;
    public LabelTokenHolder labelTokenHolder;
    public PropertyKeyTokenHolder propertyKeyTokenHolder;
    public Locks lockManager;
    public StatementLocksFactory statementLocksFactory;
    public CommitProcessFactory commitProcessFactory;
    public long transactionStartTimeout;
    public RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    public TransactionHeaderInformationFactory headerInformationFactory;
    public SchemaWriteGuard schemaWriteGuard;
    public ConstraintSemantics constraintSemantics;
    public CoreAPIAvailabilityGuard coreAPIAvailabilityGuard;
    public AccessCapability accessCapability;
    public IOLimiter ioLimiter;
    public IdReuseEligibility eligibleForIdReuse;

    public void registerProcedures(Procedures procedures) throws KernelException {
        Service.load(ProceduresProvider.class);
        procedures.registerProcedure(BuiltInProcedures.class);
        this.registerProceduresFromProvider("auth-procedures-provider", procedures);
        this.registerEditionSpecificProcedures(procedures);
    }

    protected abstract void registerEditionSpecificProcedures(Procedures var1) throws KernelException;

    protected Log authManagerLog() {
        return NullLog.getInstance();
    }

    protected void doAfterRecoveryAndStartup(DatabaseInfo databaseInfo, DependencyResolver dependencyResolver) {
        DiagnosticsManager diagnosticsManager = (DiagnosticsManager)dependencyResolver.resolveDependency(DiagnosticsManager.class);
        NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class);
        diagnosticsManager.prependProvider(new KernelDiagnostics.Versions(databaseInfo, neoStoreDataSource.getStoreId()));
        neoStoreDataSource.registerDiagnosticsWith(diagnosticsManager);
        diagnosticsManager.appendProvider(new KernelDiagnostics.StoreFiles(neoStoreDataSource.getStoreDir()));
    }

    protected void publishEditionInfo(UsageData sysInfo, DatabaseInfo databaseInfo, Config config) {
        sysInfo.set(UsageDataKeys.edition, databaseInfo.edition);
        sysInfo.set(UsageDataKeys.operationalMode, databaseInfo.operationalMode);
        config.augment(Collections.singletonMap(GraphDatabaseFacadeFactory.Configuration.editionName.name(), databaseInfo.edition.toString()));
    }

    public AuthManager createAuthManager(Config config, LogService logging, FileSystemAbstraction fileSystem, JobScheduler jobScheduler) {
        boolean authEnabled = config.get(GraphDatabaseSettings.auth_enabled);
        if (!authEnabled) {
            return this.getAuthDisabledAuthManager();
        }
        String configuredKey = config.get(GraphDatabaseSettings.auth_manager);
        ArrayList<AuthManager.Factory> wantedAuthManagerFactories = new ArrayList<AuthManager.Factory>();
        ArrayList<AuthManager.Factory> backupAuthManagerFactories = new ArrayList<AuthManager.Factory>();
        for (AuthManager.Factory candidate : Service.load(AuthManager.Factory.class)) {
            if (StreamSupport.stream(candidate.getKeys().spliterator(), false).anyMatch(configuredKey::equals)) {
                wantedAuthManagerFactories.add(candidate);
                continue;
            }
            backupAuthManagerFactories.add(candidate);
        }
        AuthManager authManager = this.tryMakeInOrder(config, logging, fileSystem, jobScheduler, wantedAuthManagerFactories);
        if (authManager == null) {
            authManager = this.tryMakeInOrder(config, logging, fileSystem, jobScheduler, backupAuthManagerFactories);
        }
        if (authManager == null) {
            logging.getUserLog(GraphDatabaseFacadeFactory.class).error("No auth manager implementation specified and no default could be loaded. It is an illegal product configuration to have auth enabled and not provide an auth manager service.");
            throw new IllegalArgumentException("Auth enabled but no auth manager found. This is an illegal product configuration.");
        }
        return authManager;
    }

    protected AuthManager getAuthDisabledAuthManager() {
        return AuthManager.NO_AUTH;
    }

    private AuthManager tryMakeInOrder(Config config, LogService logging, FileSystemAbstraction fileSystem, JobScheduler jobScheduler, List<AuthManager.Factory> authManagerFactories) {
        for (AuthManager.Factory x : authManagerFactories) {
            try {
                return x.newInstance(config, logging.getUserLogProvider(), this.authManagerLog(), fileSystem, jobScheduler);
            }
            catch (Exception e) {
                logging.getInternalLog(GraphDatabaseFacadeFactory.class).warn("Attempted to load configured auth manager with keys '%s', but failed", new Object[]{String.join((CharSequence)", ", x.getKeys()), e});
            }
        }
        return null;
    }

    protected void registerProceduresFromProvider(String key, Procedures procedures) throws KernelException {
        for (ProceduresProvider candidate : Service.load(ProceduresProvider.class)) {
            if (!candidate.matches(key)) continue;
            candidate.registerProcedures(procedures);
            return;
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "No procedure provider found with the key '" + key + "'.", new Object[0]);
    }

    protected BoltConnectionTracker createSessionTracker() {
        return BoltConnectionTracker.NOOP;
    }
}

