/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.dbms;

import org.neo4j.collection.RawIterator;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.impl.proc.Procedures;

public class NonTransactionalDbmsOperations
implements DbmsOperations {
    private final Procedures procedures;
    private final KernelTransaction transaction;

    public NonTransactionalDbmsOperations(Procedures procedures, KernelTransaction transaction) {
        this.procedures = procedures;
        this.transaction = transaction;
    }

    @Override
    public RawIterator<Object[], ProcedureException> procedureCallDbms(QualifiedName name, Object[] input) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, this.transaction);
        AccessMode mode = this.transaction.mode();
        if (mode instanceof AuthSubject) {
            ctx.put(Context.AUTH_SUBJECT, (AuthSubject)mode);
        }
        return this.procedures.callProcedure(ctx, name, input);
    }

    @Override
    public Object functionCallDbms(QualifiedName name, Object[] input) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, this.transaction);
        if (this.transaction.mode() instanceof AuthSubject) {
            AuthSubject subject = (AuthSubject)this.transaction.mode();
            ctx.put(Context.AUTH_SUBJECT, subject);
        }
        return this.procedures.callFunction(ctx, name, input);
    }

    public static class Factory
    implements DbmsOperations.Factory {
        private final Procedures procedures;

        public Factory(Procedures procedures) {
            this.procedures = procedures;
        }

        @Override
        public DbmsOperations newInstance(KernelTransaction tx) {
            return new NonTransactionalDbmsOperations(this.procedures, tx);
        }
    }
}

