/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.LegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.LegacyIndexTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class LegacyBatchIndexApplier
extends BatchTransactionApplier.Adapter {
    private final IdOrderingQueue transactionOrdering;
    private final TransactionApplicationMode mode;
    private final IndexConfigStore indexConfigStore;
    private final LegacyIndexApplierLookup applierLookup;
    private LegacyIndexTransactionApplier txApplier;
    private long lastTransactionId = -1L;

    public LegacyBatchIndexApplier(IndexConfigStore indexConfigStore, LegacyIndexApplierLookup applierLookup, IdOrderingQueue transactionOrdering, TransactionApplicationMode mode) {
        this.indexConfigStore = indexConfigStore;
        this.applierLookup = applierLookup;
        this.transactionOrdering = transactionOrdering;
        this.mode = mode;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) throws IOException {
        long activeTransactionId = transaction.transactionId();
        try {
            if (this.txApplier == null) {
                this.txApplier = new LegacyIndexTransactionApplier(this.applierLookup, this.indexConfigStore, this.mode, this.transactionOrdering);
            }
            if (transaction.requiresApplicationOrdering()) {
                this.transactionOrdering.waitFor(activeTransactionId);
                if (transaction.next() != null) {
                    this.txApplier.setTransactionId(activeTransactionId);
                } else {
                    this.lastTransactionId = activeTransactionId;
                }
            }
            return this.txApplier;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for applying tx:" + activeTransactionId + " legacy index updates", e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.txApplier == null) {
            return;
        }
        for (TransactionApplier applier : this.txApplier.applierByProvider.values()) {
            applier.close();
        }
        if (this.lastTransactionId != -1L) {
            this.transactionOrdering.removeChecked(this.lastTransactionId);
            this.lastTransactionId = -1L;
        }
    }
}

