/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.unsafe.impl.batchimport.staging.AbstractStep;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public abstract class LonelyProcessingStep
extends AbstractStep<Void> {
    private final int batchSize;
    private int batch;
    private long lastProcessingTimestamp;

    public LonelyProcessingStep(StageControl control, String name, Configuration config, StatsProvider ... additionalStatsProviders) {
        super(control, name, config, additionalStatsProviders);
        this.batchSize = config.batchSize();
    }

    @Override
    public long receive(long ticket, Void nothing) {
        new Thread(){

            @Override
            public void run() {
                LonelyProcessingStep.this.assertHealthy();
                try {
                    try {
                        LonelyProcessingStep.this.lastProcessingTimestamp = System.nanoTime();
                        LonelyProcessingStep.this.process();
                    }
                    catch (Throwable e) {
                        LonelyProcessingStep.this.issuePanic(e);
                    }
                    finally {
                        LonelyProcessingStep.this.endOfUpstream();
                    }
                }
                catch (Throwable e) {
                    if (!LonelyProcessingStep.this.isPanic()) {
                        LonelyProcessingStep.this.issuePanic(e);
                    }
                    throw e;
                }
            }
        }.start();
        return 0L;
    }

    protected abstract void process() throws Throwable;

    protected void progress(long amount) {
        this.batch = (int)((long)this.batch + amount);
        if (this.batch >= this.batchSize) {
            int batches = this.batch / this.batchSize;
            this.batch %= this.batchSize;
            this.doneBatches.addAndGet(batches);
            long time = System.nanoTime();
            this.totalProcessingTime.add(time - this.lastProcessingTimestamp);
            this.lastProcessingTimestamp = time;
        }
    }
}

