/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import org.neo4j.helpers.Service;
import org.neo4j.kernel.impl.query.NoQueryEngine;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public abstract class QueryEngineProvider
extends Service {
    public QueryEngineProvider(String name) {
        super(name, new String[0]);
    }

    protected abstract QueryExecutionEngine createEngine(Dependencies var1, GraphDatabaseAPI var2);

    public static QueryExecutionEngine initialize(Dependencies deps, GraphDatabaseAPI graphAPI, Iterable<QueryEngineProvider> providers) {
        QueryEngineProvider provider = null;
        for (QueryEngineProvider candidate : providers) {
            if (provider == null) {
                provider = candidate;
                continue;
            }
            throw new IllegalStateException("Too many query engines.");
        }
        if (provider == null) {
            return QueryEngineProvider.noEngine();
        }
        QueryExecutionEngine engine = provider.createEngine(deps, graphAPI);
        return deps.satisfyDependency(engine);
    }

    public static QueryExecutionEngine noEngine() {
        return NoQueryEngine.INSTANCE;
    }

    public static QuerySession embeddedSession(final TransactionalContext transactionalContext) {
        final Thread thread = Thread.currentThread();
        return new QuerySession(transactionalContext){
            private final String username;
            {
                super(context);
                this.username = transactionalContext.accessMode().name();
            }

            @Override
            public String toString() {
                return String.format("embedded-session\tthread\t%s\t%s", thread.getName(), this.username);
            }
        };
    }
}

