/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.FieldInjections;
import org.neo4j.kernel.impl.proc.MethodSignatureCompiler;
import org.neo4j.kernel.impl.proc.OutputMappers;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class ReflectiveProcedureCompiler {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final OutputMappers outputMappers;
    private final MethodSignatureCompiler inputSignatureDeterminer;
    private final FieldInjections fieldInjections;
    private final Log log;

    public ReflectiveProcedureCompiler(TypeMappers typeMappers, ComponentRegistry components, Log log) {
        this.inputSignatureDeterminer = new MethodSignatureCompiler(typeMappers);
        this.outputMappers = new OutputMappers(typeMappers);
        this.fieldInjections = new FieldInjections(components);
        this.log = log;
    }

    public List<CallableProcedure> compile(Class<?> procDefinition) throws KernelException {
        try {
            List procedureMethods = Arrays.stream(procDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Procedure.class)).collect(Collectors.toList());
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            MethodHandle constructor = this.constructor(procDefinition);
            ArrayList<CallableProcedure> out = new ArrayList<CallableProcedure>(procedureMethods.size());
            for (Method method : procedureMethods) {
                out.add(this.compileProcedure(procDefinition, constructor, method));
            }
            out.sort((a, b) -> a.signature().name().toString().compareTo(b.signature().name().toString()));
            return out;
        }
        catch (KernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Failed to compile procedure defined in `%s`: %s", procDefinition.getSimpleName(), e.getMessage());
        }
    }

    private ReflectiveProcedure compileProcedure(Class<?> procDefinition, MethodHandle constructor, Method method) throws ProcedureException, IllegalAccessException {
        ProcedureSignature.ProcedureName procName = this.extractName(procDefinition, method);
        List<ProcedureSignature.FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        OutputMappers.OutputMapper outputMapper = this.outputMappers.mapper(method);
        MethodHandle procedureMethod = this.lookup.unreflect(method);
        List<FieldInjections.FieldSetter> setters = this.fieldInjections.setters(procDefinition);
        ProcedureSignature.Mode mode = ProcedureSignature.Mode.READ_ONLY;
        Optional<String> description = this.description(method);
        Procedure procedure = method.getAnnotation(Procedure.class);
        if (procedure.mode().equals((Object)Procedure.Mode.DBMS)) {
            mode = ProcedureSignature.Mode.DBMS;
        } else if (procedure.mode().equals((Object)Procedure.Mode.SCHEMA)) {
            mode = ProcedureSignature.Mode.SCHEMA_WRITE;
        } else if (procedure.mode().equals((Object)Procedure.Mode.WRITE)) {
            mode = ProcedureSignature.Mode.READ_WRITE;
        }
        if (method.isAnnotationPresent(PerformsWrites.class)) {
            if (!procedure.mode().equals((Object)Procedure.Mode.DEFAULT)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Conflicting procedure annotation, cannot use PerformsWrites and mode", new Object[0]);
            }
            mode = ProcedureSignature.Mode.READ_WRITE;
        }
        String deprecatedBy = procedure.deprecatedBy().trim();
        Optional<String> deprecated = Optional.empty();
        if (method.isAnnotationPresent(Deprecated.class)) {
            deprecated = Optional.of(deprecatedBy);
        } else if (!deprecatedBy.isEmpty()) {
            this.log.warn("Use of @Procedure(deprecatedBy) without @Deprecated in " + procName);
            deprecated = Optional.of(deprecatedBy);
        }
        ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputMapper.signature(), mode, deprecated, procedure.allowed(), description);
        return new ReflectiveProcedure(signature, constructor, procedureMethod, outputMapper, setters);
    }

    private Optional<String> description(Method method) {
        if (method.isAnnotationPresent(Description.class)) {
            return Optional.of(method.getAnnotation(Description.class).value());
        }
        return Optional.empty();
    }

    private MethodHandle constructor(Class<?> procDefinition) throws ProcedureException {
        try {
            return this.lookup.unreflectConstructor(procDefinition.getConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, (Throwable)e, "Unable to find a usable public no-argument constructor in the class `%s`. Please add a valid, public constructor, recompile the class and try again.", procDefinition.getSimpleName());
        }
    }

    private ProcedureSignature.ProcedureName extractName(Class<?> procDefinition, Method m) {
        String procName;
        String valueName = m.getAnnotation(Procedure.class).value();
        String definedName = m.getAnnotation(Procedure.class).name();
        String string = procName = definedName.trim().isEmpty() ? valueName : definedName;
        if (procName.trim().length() > 0) {
            String[] split = procName.split("\\.");
            if (split.length == 1) {
                return new ProcedureSignature.ProcedureName(new String[0], split[0]);
            }
            int lastElement = split.length - 1;
            return new ProcedureSignature.ProcedureName(Arrays.copyOf(split, lastElement), split[lastElement]);
        }
        Package pkg = procDefinition.getPackage();
        String[] namespace = pkg == null ? new String[]{} : pkg.getName().split("\\.");
        String name = m.getName();
        return new ProcedureSignature.ProcedureName(namespace, name);
    }

    private static class ReflectiveProcedure
    implements CallableProcedure {
        private final ProcedureSignature signature;
        private final MethodHandle constructor;
        private final MethodHandle procedureMethod;
        private final OutputMappers.OutputMapper outputMapper;
        private final List<FieldInjections.FieldSetter> fieldSetters;

        public ReflectiveProcedure(ProcedureSignature signature, MethodHandle constructor, MethodHandle procedureMethod, OutputMappers.OutputMapper outputMapper, List<FieldInjections.FieldSetter> fieldSetters) {
            this.signature = signature;
            this.constructor = constructor;
            this.procedureMethod = procedureMethod;
            this.outputMapper = outputMapper;
            this.fieldSetters = fieldSetters;
        }

        @Override
        public ProcedureSignature signature() {
            return this.signature;
        }

        @Override
        public RawIterator<Object[], ProcedureException> apply(CallableProcedure.Context ctx, Object[] input) throws ProcedureException {
            try {
                int numberOfDeclaredArguments = this.signature.inputSignature().size();
                if (numberOfDeclaredArguments != input.length) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Procedure `%s` takes %d arguments but %d was provided.", this.signature.name(), numberOfDeclaredArguments, input.length);
                }
                Object cls = this.constructor.invoke();
                for (FieldInjections.FieldSetter setter : this.fieldSetters) {
                    setter.apply(ctx, cls);
                }
                Object[] args = new Object[numberOfDeclaredArguments + 1];
                args[0] = cls;
                System.arraycopy(input, 0, args, 1, numberOfDeclaredArguments);
                Object rs = this.procedureMethod.invokeWithArguments(args);
                if (rs == null) {
                    return Iterators.asRawIterator(Collections.emptyIterator());
                }
                return new MappingIterator(((Stream)rs).iterator());
            }
            catch (Throwable throwable) {
                if (throwable instanceof Status.HasStatus) {
                    throw new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[0]);
                }
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke procedure `%s`: %s", this.signature.name(), "Caused by: " + throwable);
            }
        }

        private class MappingIterator
        implements RawIterator<Object[], ProcedureException> {
            private final Iterator<?> out;

            public MappingIterator(Iterator<?> out) {
                this.out = out;
            }

            public boolean hasNext() throws ProcedureException {
                try {
                    return this.out.hasNext();
                }
                catch (RuntimeException e) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to call procedure `%s`: %s", ReflectiveProcedure.this.signature, e.getMessage());
                }
            }

            public Object[] next() throws ProcedureException {
                try {
                    Object record = this.out.next();
                    return ReflectiveProcedure.this.outputMapper.apply(record);
                }
                catch (RuntimeException e) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to call procedure `%s`: %s", ReflectiveProcedure.this.signature, e.getMessage());
                }
            }
        }
    }
}

