/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.guard;

import java.time.Clock;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.GuardTimeoutException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.logging.Log;

public class TimeoutGuard
implements Guard {
    private final Log log;
    private Clock clock;

    public TimeoutGuard(Clock clock, Log log) {
        this.log = log;
        this.clock = clock;
    }

    @Override
    public void check(KernelStatement statement) {
        this.check(statement.getTransaction());
    }

    private void check(KernelTransactionImplementation transaction) {
        if (transaction.timeout() > 0L) {
            this.check(TimeoutGuard.getMaxTransactionCompletionTime(transaction), "Transaction timeout.");
        }
    }

    private void check(long maxCompletionTime, String timeoutDescription) {
        long now = this.clock.millis();
        if (maxCompletionTime < now) {
            long overtime = now - maxCompletionTime;
            String message = timeoutDescription + " (Overtime: " + overtime + " ms).";
            this.log.warn(message);
            throw new GuardTimeoutException(message, overtime);
        }
    }

    private static long getMaxTransactionCompletionTime(KernelTransactionImplementation transaction) {
        return transaction.startTime() + transaction.timeout();
    }
}

