/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.builtinprocs.AwaitIndexProcedure;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BuiltInProcedures {
    @Context
    public KernelTransaction tx;

    @Description(value="List all labels in the database.")
    @Procedure(name="db.labels", mode=Procedure.Mode.READ)
    public Stream<LabelResult> listLabels() {
        return TokenAccess.LABELS.inUse(this.tx.acquireStatement()).map(x$0 -> new LabelResult((Label)x$0)).stream();
    }

    @Description(value="List all property keys in the database.")
    @Procedure(name="db.propertyKeys", mode=Procedure.Mode.READ)
    public Stream<PropertyKeyResult> listPropertyKeys() {
        return TokenAccess.PROPERTY_KEYS.inUse(this.tx.acquireStatement()).map(x$0 -> new PropertyKeyResult((String)x$0)).stream();
    }

    @Description(value="List all relationship types in the database.")
    @Procedure(name="db.relationshipTypes", mode=Procedure.Mode.READ)
    public Stream<RelationshipTypeResult> listRelationshipTypes() {
        return TokenAccess.RELATIONSHIP_TYPES.inUse(this.tx.acquireStatement()).map(x$0 -> new RelationshipTypeResult((RelationshipType)x$0)).stream();
    }

    @Description(value="List all indexes in the database.")
    @Procedure(name="db.indexes", mode=Procedure.Mode.READ)
    public Stream<IndexResult> listIndexes() throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations operations = statement.readOperations();
            StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
            List indexes = Iterators.asList(operations.indexesGetAll());
            Set uniqueIndexes = Iterators.asSet(operations.uniqueIndexesGetAll());
            indexes.addAll(uniqueIndexes);
            indexes.sort((a, b) -> a.userDescription(tokens).compareTo(b.userDescription(tokens)));
            ArrayList<IndexResult> result = new ArrayList<IndexResult>();
            for (IndexDescriptor index : indexes) {
                try {
                    String type = uniqueIndexes.contains(index) ? IndexType.NODE_UNIQUE_PROPERTY.typeName() : IndexType.NODE_LABEL_PROPERTY.typeName();
                    result.add(new IndexResult("INDEX ON " + index.userDescription(tokens), operations.indexGetState(index).toString(), type));
                }
                catch (IndexNotFoundKernelException e) {
                    throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on ", index.userDescription(tokens));
                }
            }
            Stream stream = result.stream();
            return stream;
        }
    }

    @Description(value="Await indexes in the database to come online.")
    @Procedure(name="db.awaitIndex", mode=Procedure.Mode.READ)
    public void awaitIndex(@Name(value="label") String labelName, @Name(value="property") String propertyKeyName, @Name(value="timeOutSeconds", defaultValue="300") long timeout) throws ProcedureException {
        try (AwaitIndexProcedure awaitIndexProcedure = new AwaitIndexProcedure(this.tx);){
            awaitIndexProcedure.execute(labelName, propertyKeyName, timeout, TimeUnit.SECONDS);
        }
    }

    @Description(value="List all constraints in the database.")
    @Procedure(name="db.constraints", mode=Procedure.Mode.READ)
    public Stream<ConstraintResult> listConstraints() {
        Statement statement = this.tx.acquireStatement();
        ReadOperations operations = statement.readOperations();
        StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
        return (Stream)Iterators.asList(operations.constraintsGetAll()).stream().map(constraint -> constraint.userDescription(tokens)).sorted().map(x$0 -> new ConstraintResult((String)x$0)).onClose(() -> ((Statement)statement).close());
    }

    @Description(value="List all procedures in the DBMS.")
    @Procedure(name="dbms.procedures", mode=Procedure.Mode.READ)
    public Stream<ProcedureResult> listProcedures() {
        try (Statement statement = this.tx.acquireStatement();){
            Stream<ProcedureResult> stream = statement.readOperations().proceduresGetAll().stream().sorted((a, b) -> a.name().toString().compareTo(b.name().toString())).map(x$0 -> new ProcedureResult((ProcedureSignature)x$0));
            return stream;
        }
    }

    private static enum IndexType {
        NODE_LABEL_PROPERTY("node_label_property"),
        NODE_UNIQUE_PROPERTY("node_unique_property");

        private final String typeName;

        private IndexType(String typeName) {
            this.typeName = typeName;
        }

        public String typeName() {
            return this.typeName;
        }
    }

    public class ProcedureResult {
        public final String name;
        public final String signature;
        public final String description;

        private ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
        }
    }

    public class ConstraintResult {
        public final String description;

        private ConstraintResult(String description) {
            this.description = description;
        }
    }

    public class IndexResult {
        public final String description;
        public final String state;
        public final String type;

        private IndexResult(String description, String state, String type) {
            this.description = description;
            this.state = state;
            this.type = type;
        }
    }

    public class RelationshipTypeResult {
        public final String relationshipType;

        private RelationshipTypeResult(RelationshipType relationshipType) {
            this.relationshipType = relationshipType.name();
        }
    }

    public class PropertyKeyResult {
        public final String propertyKey;

        private PropertyKeyResult(String propertyKey) {
            this.propertyKey = propertyKey;
        }
    }

    public class LabelResult {
        public final String label;

        private LabelResult(Label label) {
            this.label = label.name();
        }
    }
}

