/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.api.TransactionToApply;

public class TransactionQueue {
    private final int maxSize;
    private final Applier applier;
    private TransactionToApply first;
    private TransactionToApply last;
    private int size;

    public TransactionQueue(int maxSize, Applier applier) {
        this.maxSize = maxSize;
        this.applier = applier;
    }

    public void queue(TransactionToApply transaction) throws Exception {
        if (this.isEmpty()) {
            this.first = this.last = transaction;
        } else {
            this.last.next(transaction);
            this.last = transaction;
        }
        if (++this.size == this.maxSize) {
            this.empty();
        }
    }

    public void empty() throws Exception {
        if (this.size > 0) {
            this.applier.apply(this.first, this.last);
            this.last = null;
            this.first = null;
            this.size = 0;
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public TransactionToApply first() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Nothing in queue");
        }
        return this.first;
    }

    public TransactionToApply last() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Nothing in queue");
        }
        return this.last;
    }

    @FunctionalInterface
    public static interface Applier {
        public void apply(TransactionToApply var1, TransactionToApply var2) throws Exception;
    }
}

