/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.io.IOException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.exception.InvalidArgumentsException;

public interface AuthSubject
extends AccessMode {
    public static final AuthSubject ANONYMOUS = new AuthSubject(){

        @Override
        public void logout() {
        }

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.FAILURE;
        }

        @Override
        public void setPassword(String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
            throw new AuthorizationViolationException("Anonymous cannot change password");
        }

        @Override
        public boolean allowsProcedureWith(String[] roleNames) {
            return false;
        }

        @Override
        public boolean allowsReads() {
            return false;
        }

        @Override
        public boolean allowsWrites() {
            return false;
        }

        @Override
        public boolean allowsSchemaWrites() {
            return false;
        }

        @Override
        public boolean overrideOriginalMode() {
            return false;
        }

        @Override
        public AuthorizationViolationException onViolation(String msg) {
            return new AuthorizationViolationException(msg);
        }

        @Override
        public String name() {
            return "<anonymous>";
        }

        @Override
        public String username() {
            return "";
        }
    };
    public static final AuthSubject AUTH_DISABLED = new AuthSubject(){

        @Override
        public boolean allowsReads() {
            return true;
        }

        @Override
        public boolean allowsWrites() {
            return true;
        }

        @Override
        public boolean allowsSchemaWrites() {
            return true;
        }

        @Override
        public boolean overrideOriginalMode() {
            return false;
        }

        @Override
        public AuthorizationViolationException onViolation(String msg) {
            return new AuthorizationViolationException(msg);
        }

        @Override
        public String name() {
            return "<auth disabled>";
        }

        @Override
        public String username() {
            return "";
        }

        @Override
        public void logout() {
        }

        @Override
        public AuthenticationResult getAuthenticationResult() {
            return AuthenticationResult.SUCCESS;
        }

        @Override
        public void setPassword(String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
        }

        @Override
        public boolean allowsProcedureWith(String[] roleNames) {
            return true;
        }
    };

    public void logout();

    public AuthenticationResult getAuthenticationResult();

    public void setPassword(String var1, boolean var2) throws IOException, InvalidArgumentsException;

    public boolean allowsProcedureWith(String[] var1) throws InvalidArgumentsException;

    public String username();
}

