/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.Direction;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class NodeRelationshipCache
implements MemoryStatsVisitor.Visitable {
    private static final int CHUNK_SIZE = 1000000;
    private static final long EMPTY = -1L;
    private static final long MAX_RELATIONSHIP_ID = 0xFFFFFFFFFFFEL;
    static final int MAX_COUNT = 0x3FFFFFFE;
    private static final int ID_SIZE = 6;
    private static final int COUNT_SIZE = 4;
    private static final int ID_AND_COUNT_SIZE = 10;
    private static final int SPARSE_ID_OFFSET = 0;
    private static final int SPARSE_COUNT_OFFSET = 6;
    private static final int DENSE_NODE_CHANGED_MASK = Integer.MIN_VALUE;
    private static final int SPARSE_NODE_CHANGED_MASK = 0x40000000;
    private static final int NODE_CHANGED_MASKS = -1073741824;
    private static final int COUNT_MASK = 0x3FFFFFFF;
    private final ByteArray array;
    private byte[] chunkChangedArray;
    private final int denseNodeThreshold;
    private final RelGroupCache relGroupCache;
    private long highId;
    private volatile boolean forward = true;
    private final int chunkSize;
    public static final GroupVisitor NO_GROUP_VISITOR = (nodeId, next, out, in, loop) -> -1L;

    public NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold) {
        this(arrayFactory, denseNodeThreshold, 1000000, 0L);
    }

    NodeRelationshipCache(NumberArrayFactory arrayFactory, int denseNodeThreshold, int chunkSize, long base) {
        this.chunkSize = chunkSize;
        this.array = arrayFactory.newDynamicByteArray(chunkSize, NodeRelationshipCache.minusOneBytes(10));
        this.denseNodeThreshold = denseNodeThreshold;
        this.relGroupCache = new RelGroupCache(arrayFactory, chunkSize, base);
    }

    private static byte[] minusOneBytes(int length) {
        byte[] bytes = new byte[length];
        Arrays.fill(bytes, (byte)-1);
        return bytes;
    }

    public int incrementCount(long nodeId) {
        return NodeRelationshipCache.incrementCount(this.array, nodeId, 6);
    }

    void setCount(long nodeId, int count) {
        NodeRelationshipCache.assertValidCount(nodeId, count);
        this.array.setInt(nodeId, 6, count);
    }

    private static void assertValidCount(long nodeId, int count) {
        if (count > 0x3FFFFFFE) {
            throw new IllegalStateException("Tried to increment count of " + nodeId + " to " + count + ", which is too big in one single import");
        }
    }

    public void setHighNodeId(long nodeId) {
        this.highId = nodeId;
        this.chunkChangedArray = new byte[this.chunkOf(nodeId) + 1];
    }

    public long getHighNodeId() {
        return this.highId;
    }

    private static int getCount(ByteArray array, long index, int offset) {
        long rawCount = array.getInt(index, offset) & 0x3FFFFFFF;
        if (rawCount == 0x3FFFFFFFL) {
            return 0;
        }
        return (int)rawCount;
    }

    private static int incrementCount(ByteArray array, long index, int offset) {
        array = (ByteArray)array.at(index);
        int count = NodeRelationshipCache.getCount(array, index, offset) + 1;
        NodeRelationshipCache.assertValidCount(index, count);
        array.setInt(index, offset, count);
        return count;
    }

    public boolean isDense(long nodeId) {
        return this.isDense(this.array, nodeId);
    }

    private boolean isDense(ByteArray array, long nodeId) {
        if ((long)this.denseNodeThreshold == -1L) {
            return false;
        }
        return NodeRelationshipCache.getCount(array, nodeId, 6) >= this.denseNodeThreshold;
    }

    public long getAndPutRelationship(long nodeId, Direction direction, long firstRelId, boolean incrementCount) {
        if (firstRelId > 0xFFFFFFFFFFFEL) {
            throw new IllegalArgumentException("Illegal relationship id, max is 281474976710654");
        }
        ByteArray array = (ByteArray)this.array.at(nodeId);
        long existingId = NodeRelationshipCache.all48Bits(array, nodeId, 0);
        boolean dense = this.isDense(array, nodeId);
        boolean wasChanged = this.markAsChanged(array, nodeId, NodeRelationshipCache.changeMask(dense));
        this.markChunkAsChanged(nodeId, dense);
        if (dense) {
            if (existingId == -1L) {
                existingId = this.relGroupCache.allocate();
                this.setRelationshipId(array, nodeId, existingId);
                wasChanged = false;
            }
            return this.relGroupCache.putRelationship(existingId, direction, firstRelId, incrementCount, wasChanged);
        }
        this.setRelationshipId(array, nodeId, firstRelId);
        return wasChanged ? -1L : existingId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void markChunkAsChanged(long nodeId, boolean dense) {
        int chunk;
        byte mask = NodeRelationshipCache.chunkChangeMask(dense);
        if (this.chunkHasChange(nodeId, mask) || (this.chunkChangedArray[chunk = this.chunkOf(nodeId)] & mask) != 0) return;
        byte[] byArray = this.chunkChangedArray;
        synchronized (this.chunkChangedArray) {
            int n = chunk;
            this.chunkChangedArray[n] = (byte)(this.chunkChangedArray[n] | mask);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    private int chunkOf(long nodeId) {
        return Math.toIntExact(nodeId / (long)this.chunkSize);
    }

    private static byte chunkChangeMask(boolean dense) {
        return (byte)(1 << (dense ? 1 : 0));
    }

    private boolean markAsChanged(ByteArray array, long nodeId, int mask) {
        boolean changeBitWasFlipped;
        int bits = array.getInt(nodeId, 6);
        boolean changeBitIsSet = (bits & mask) != 0;
        boolean bl = changeBitWasFlipped = changeBitIsSet != this.forward;
        if (changeBitWasFlipped) {
            array.setInt(nodeId, 6, bits ^= mask);
        }
        return changeBitWasFlipped;
    }

    private static boolean nodeIsChanged(ByteArray array, long nodeId, long mask) {
        int bits = array.getInt(nodeId, 6);
        if (bits == -1) {
            return false;
        }
        return ((long)bits & mask) != 0L;
    }

    private void setRelationshipId(ByteArray array, long nodeId, long firstRelId) {
        array.set6ByteLong(nodeId, 0, firstRelId);
    }

    private static long getRelationshipId(ByteArray array, long nodeId) {
        return array.get6ByteLong(nodeId, 0);
    }

    private static long all48Bits(ByteArray array, long index, int offset) {
        return NodeRelationshipCache.all48Bits(array.get6ByteLong(index, offset));
    }

    private static long all48Bits(long raw) {
        return raw == -1L ? raw : raw & 0xFFFFFFFFFFFFL;
    }

    public long getFirstRel(long nodeId, GroupVisitor visitor) {
        assert (this.forward) : "This should only be done at forward scan";
        ByteArray array = (ByteArray)this.array.at(nodeId);
        long id = NodeRelationshipCache.getRelationshipId(array, nodeId);
        if (id != -1L && this.isDense(array, nodeId)) {
            return this.relGroupCache.visitGroup(nodeId, id, visitor);
        }
        return id;
    }

    public void setForwardScan(boolean forward) {
        this.forward = forward;
    }

    public int getCount(long nodeId, Direction direction) {
        ByteArray array = (ByteArray)this.array.at(nodeId);
        if (this.isDense(array, nodeId)) {
            long id = NodeRelationshipCache.getRelationshipId(array, nodeId);
            return id == -1L ? 0 : this.relGroupCache.getAndResetCount(id, direction);
        }
        return NodeRelationshipCache.getCount(array, nodeId, 6);
    }

    public String toString() {
        return this.array.toString();
    }

    public void close() {
        this.array.close();
        this.relGroupCache.close();
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        this.array.acceptMemoryStatsVisitor(visitor);
        this.relGroupCache.acceptMemoryStatsVisitor(visitor);
    }

    private static int changeMask(boolean dense) {
        return dense ? Integer.MIN_VALUE : 0x40000000;
    }

    public void visitChangedNodes(NodeChangeVisitor visitor, boolean denseNodes) {
        long mask = NodeRelationshipCache.changeMask(denseNodes);
        byte chunkMask = NodeRelationshipCache.chunkChangeMask(denseNodes);
        long nodeId = 0L;
        while (nodeId < this.highId) {
            if (!this.chunkHasChange(nodeId, chunkMask)) {
                nodeId += (long)this.chunkSize;
                continue;
            }
            ByteArray chunk = (ByteArray)this.array.at(nodeId);
            for (int i = 0; i < this.chunkSize && nodeId < this.highId; ++i, ++nodeId) {
                if (this.isDense(chunk, nodeId) != denseNodes || !NodeRelationshipCache.nodeIsChanged(chunk, nodeId, mask)) continue;
                visitor.change(nodeId, chunk);
            }
        }
    }

    public void clearChangedChunks(boolean denseNodes) {
        byte chunkMask = NodeRelationshipCache.chunkChangeMask(denseNodes);
        int i = 0;
        while (i < this.chunkChangedArray.length) {
            int n = i++;
            this.chunkChangedArray[n] = (byte)(this.chunkChangedArray[n] & ~chunkMask);
        }
    }

    private boolean chunkHasChange(long nodeId, byte chunkMask) {
        int chunkId = this.chunkOf(nodeId);
        return (this.chunkChangedArray[chunkId] & chunkMask) != 0;
    }

    @FunctionalInterface
    public static interface NodeChangeVisitor {
        public void change(long var1, ByteArray var3);
    }

    private static class RelGroupCache
    implements AutoCloseable,
    MemoryStatsVisitor.Visitable {
        private static final int NEXT_OFFSET = 0;
        private static final int BASE_IDS_OFFSET = 6;
        private final long base;
        private final ByteArray array;
        private final AtomicLong nextFreeId;

        RelGroupCache(NumberArrayFactory arrayFactory, long chunkSize, long base) {
            this.base = base;
            assert (chunkSize > 0L);
            this.array = arrayFactory.newDynamicByteArray(chunkSize, NodeRelationshipCache.minusOneBytes(6 + 10 * Direction.values().length));
            this.nextFreeId = new AtomicLong(base);
        }

        private void clearRelationships(ByteArray array, long relGroupId) {
            array.set6ByteLong(relGroupId, RelGroupCache.directionOffset(Direction.OUTGOING), -1L);
            array.set6ByteLong(relGroupId, RelGroupCache.directionOffset(Direction.INCOMING), -1L);
            array.set6ByteLong(relGroupId, RelGroupCache.directionOffset(Direction.BOTH), -1L);
        }

        int getAndResetCount(long id, Direction direction) {
            id = this.rebase(id);
            ByteArray array = (ByteArray)this.array.at(id);
            if (id == -1L) {
                return 0;
            }
            int offset = RelGroupCache.countOffset(direction);
            int count = NodeRelationshipCache.getCount(array, id, offset);
            array.setInt(id, offset, 0);
            return count;
        }

        private long rebase(long index) {
            return index - this.base;
        }

        private long nextFreeId() {
            return this.nextFreeId.getAndIncrement();
        }

        private long visitGroup(long nodeId, long relGroupIndex, GroupVisitor visitor) {
            long index = this.rebase(relGroupIndex);
            ByteArray array = (ByteArray)this.array.at(index);
            long out = NodeRelationshipCache.all48Bits(array, index, RelGroupCache.directionOffset(Direction.OUTGOING));
            long in = NodeRelationshipCache.all48Bits(array, index, RelGroupCache.directionOffset(Direction.INCOMING));
            long loop = NodeRelationshipCache.all48Bits(array, index, RelGroupCache.directionOffset(Direction.BOTH));
            long next = NodeRelationshipCache.all48Bits(array, index, 0);
            long nextId = out == -1L && in == -1L && loop == -1L ? -1L : visitor.visit(nodeId, next, out, in, loop);
            array.set6ByteLong(index, 0, nextId);
            return nextId;
        }

        private static int directionOffset(Direction direction) {
            return 6 + direction.ordinal() * 10;
        }

        private static int countOffset(Direction direction) {
            return RelGroupCache.directionOffset(direction) + 6;
        }

        long allocate() {
            return this.nextFreeId();
        }

        long putRelationship(long relGroupIndex, Direction direction, long relId, boolean increment, boolean clear) {
            long previousId;
            long index = this.rebase(relGroupIndex);
            ByteArray array = (ByteArray)this.array.at(index);
            int directionOffset = RelGroupCache.directionOffset(direction);
            if (clear) {
                this.clearRelationships(array, index);
                previousId = -1L;
            } else {
                previousId = NodeRelationshipCache.all48Bits(array, index, directionOffset);
            }
            array.set6ByteLong(index, directionOffset, relId);
            if (increment) {
                NodeRelationshipCache.incrementCount(array, index, RelGroupCache.countOffset(direction));
            }
            return previousId;
        }

        @Override
        public void close() {
            if (this.array != null) {
                this.array.close();
            }
        }

        @Override
        public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
            this.array.acceptMemoryStatsVisitor(visitor);
        }
    }

    public static interface GroupVisitor {
        public long visit(long var1, long var3, long var5, long var7, long var9);
    }
}

